@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.ResourceShareArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Resource Share resource.
 * For information about Resource Manager Resource Share and how to use it, see [What is Resource Share](https://www.alibabacloud.com/help/en/doc-detail/94475.htm).
 * > **NOTE:** Available since v1.111.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.resourcemanager.ResourceShare("example", {resourceShareName: name});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.resourcemanager.ResourceShare("example", resource_share_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.ResourceManager.ResourceShare("example", new()
 *     {
 *         ResourceShareName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewResourceShare(ctx, "example", &resourcemanager.ResourceShareArgs{
 * 			ResourceShareName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourceShare;
 * import com.pulumi.alicloud.resourcemanager.ResourceShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new ResourceShare("example", ResourceShareArgs.builder()
 *             .resourceShareName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:ResourceShare
 *     properties:
 *       resourceShareName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Resource Share can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/resourceShare:ResourceShare example <id>
 * ```
 * @property resourceShareName The name of resource share.
 */
public data class ResourceShareArgs(
    public val resourceShareName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.ResourceShareArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.ResourceShareArgs =
        com.pulumi.alicloud.resourcemanager.ResourceShareArgs.builder()
            .resourceShareName(resourceShareName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceShareArgs].
 */
@PulumiTagMarker
public class ResourceShareArgsBuilder internal constructor() {
    private var resourceShareName: Output<String>? = null

    /**
     * @param value The name of resource share.
     */
    @JvmName("hlptulgjhcvyyjxo")
    public suspend fun resourceShareName(`value`: Output<String>) {
        this.resourceShareName = value
    }

    /**
     * @param value The name of resource share.
     */
    @JvmName("axdhbvsgvsjvlmxi")
    public suspend fun resourceShareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceShareName = mapped
    }

    internal fun build(): ResourceShareArgs = ResourceShareArgs(
        resourceShareName = resourceShareName,
    )
}
