@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getAccountDeletionCheckTaskPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getAccountsPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getControlPoliciesPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getControlPolicyAttachmentsPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getDelegatedAdministratorsPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getFoldersPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getHandshakesPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getPoliciesPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getPolicyAttachmentsPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getPolicyVersionsPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getResourceDirectoriesPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getResourceGroupsPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getResourceSharesPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getRolesPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getSharedResourcesPlain
import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions.getSharedTargetsPlain
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetAccountDeletionCheckTaskPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetAccountDeletionCheckTaskPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetAccountsPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetAccountsPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetControlPoliciesPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetControlPoliciesPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetControlPolicyAttachmentsPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetControlPolicyAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetDelegatedAdministratorsPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetDelegatedAdministratorsPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetFoldersPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetFoldersPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetHandshakesPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetHandshakesPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetPoliciesPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetPoliciesPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetPolicyAttachmentsPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetPolicyAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetPolicyVersionsPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetPolicyVersionsPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetResourceDirectoriesPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetResourceDirectoriesPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetResourceGroupsPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetResourceGroupsPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetResourceSharesPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetResourceSharesPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetRolesPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetRolesPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetSharedResourcesPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetSharedResourcesPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetSharedTargetsPlainArgs
import com.pulumi.alicloud.resourcemanager.kotlin.inputs.GetSharedTargetsPlainArgsBuilder
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetAccountDeletionCheckTaskResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetAccountsResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetControlPoliciesResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetControlPolicyAttachmentsResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetDelegatedAdministratorsResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetFoldersResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetHandshakesResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetPoliciesResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetPolicyAttachmentsResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetPolicyVersionsResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetResourceDirectoriesResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetResourceGroupsResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetResourceSharesResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetRolesResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetSharedResourcesResult
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetSharedTargetsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetAccountDeletionCheckTaskResult.Companion.toKotlin as getAccountDeletionCheckTaskResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetAccountsResult.Companion.toKotlin as getAccountsResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetControlPoliciesResult.Companion.toKotlin as getControlPoliciesResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetControlPolicyAttachmentsResult.Companion.toKotlin as getControlPolicyAttachmentsResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetDelegatedAdministratorsResult.Companion.toKotlin as getDelegatedAdministratorsResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetFoldersResult.Companion.toKotlin as getFoldersResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetHandshakesResult.Companion.toKotlin as getHandshakesResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetPoliciesResult.Companion.toKotlin as getPoliciesResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetPolicyAttachmentsResult.Companion.toKotlin as getPolicyAttachmentsResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetPolicyVersionsResult.Companion.toKotlin as getPolicyVersionsResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetResourceDirectoriesResult.Companion.toKotlin as getResourceDirectoriesResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetResourceGroupsResult.Companion.toKotlin as getResourceGroupsResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetResourceSharesResult.Companion.toKotlin as getResourceSharesResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetRolesResult.Companion.toKotlin as getRolesResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetSharedResourcesResult.Companion.toKotlin as getSharedResourcesResultToKotlin
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetSharedTargetsResult.Companion.toKotlin as getSharedTargetsResultToKotlin

public object ResourcemanagerFunctions {
    /**
     * Using this data source can open Resource Manager Account Deletion Check Task.
     * For information about Resource Manager Account Deletion Check Task and how to use it, see [What is Resource Manager Account Deletion Check Task](https://www.alibabacloud.com/help/en/resource-management/latest/check-account-delete).
     * > **NOTE:** Available in v1.187.0+.
     * > **NOTE:** The member deletion feature is in invitational preview. You can contact the service manager of Alibaba Cloud to apply for a trial.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const task = alicloud.resourcemanager.getAccountDeletionCheckTask({
     *     accountId: "your_account_id",
     * });
     * export const abandonAbleChecksIds = task.then(task => task.abandonAbleChecks.map(__item => __item.checkId));
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * task = alicloud.resourcemanager.get_account_deletion_check_task(account_id="your_account_id")
     * pulumi.export("abandonAbleChecksIds", [__item&#46;check_id for __item in task&#46;abandon_able_checks])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var task = AliCloud.ResourceManager.GetAccountDeletionCheckTask.Invoke(new()
     *     {
     *         AccountId = "your_account_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["abandonAbleChecksIds"] = task.Apply(getAccountDeletionCheckTaskResult => getAccountDeletionCheckTaskResult.AbandonAbleChecks).Select(__item => __item.CheckId).ToList(),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * task, err := resourcemanager.GetAccountDeletionCheckTask(ctx, &resourcemanager.GetAccountDeletionCheckTaskArgs{
     * AccountId: "your_account_id",
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("abandonAbleChecksIds", pulumi.StringArray(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:5,11-44)))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetAccountDeletionCheckTaskArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var task = ResourcemanagerFunctions.getAccountDeletionCheckTask(GetAccountDeletionCheckTaskArgs.builder()
     *             .accountId("your_account_id")
     *             .build());
     *         ctx.export("abandonAbleChecksIds", task.applyValue(getAccountDeletionCheckTaskResult -> getAccountDeletionCheckTaskResult.abandonAbleChecks()).stream().map(element -> element.checkId()).collect(toList()));
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccountDeletionCheckTask.
     * @return A collection of values returned by getAccountDeletionCheckTask.
     */
    public suspend fun getAccountDeletionCheckTask(argument: GetAccountDeletionCheckTaskPlainArgs): GetAccountDeletionCheckTaskResult =
        getAccountDeletionCheckTaskResultToKotlin(getAccountDeletionCheckTaskPlain(argument.toJava()).await())

    /**
     * @see [getAccountDeletionCheckTask].
     * @param accountId The ID of the member that you want to delete.
     * @return A collection of values returned by getAccountDeletionCheckTask.
     */
    public suspend fun getAccountDeletionCheckTask(accountId: String): GetAccountDeletionCheckTaskResult {
        val argument = GetAccountDeletionCheckTaskPlainArgs(
            accountId = accountId,
        )
        return getAccountDeletionCheckTaskResultToKotlin(getAccountDeletionCheckTaskPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccountDeletionCheckTask].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetAccountDeletionCheckTaskPlainArgs].
     * @return A collection of values returned by getAccountDeletionCheckTask.
     */
    public suspend fun getAccountDeletionCheckTask(argument: suspend GetAccountDeletionCheckTaskPlainArgsBuilder.() -> Unit): GetAccountDeletionCheckTaskResult {
        val builder = GetAccountDeletionCheckTaskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountDeletionCheckTaskResultToKotlin(getAccountDeletionCheckTaskPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Accounts of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.86.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.resourcemanager.getAccounts({});
     * export const firstAccountId = _default.then(_default => _default.accounts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.resourcemanager.get_accounts()
     * pulumi.export("firstAccountId", default.accounts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ResourceManager.GetAccounts.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstAccountId"] = @default&#46;Apply(@default => @default&#46;Apply(getAccountsResult => getAccountsResult&#46;Accounts[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := resourcemanager.GetAccounts(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstAccountId", _default.Accounts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ResourcemanagerFunctions.getAccounts();
     *         ctx.export("firstAccountId", default_.accounts()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getAccounts
     *       Arguments: {}
     * outputs:
     *   firstAccountId: ${default.accounts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccounts.
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: GetAccountsPlainArgs): GetAccountsResult =
        getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())

    /**
     * @see [getAccounts].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of account IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of account, valid values: `CreateCancelled`, `CreateExpired`, `CreateFailed`, `CreateSuccess`, `CreateVerifying`, `InviteSuccess`, `PromoteCancelled`, `PromoteExpired`, `PromoteFailed`, `PromoteSuccess`, and `PromoteVerifying`.
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAccountsResult {
        val argument = GetAccountsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetAccountsPlainArgs].
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: suspend GetAccountsPlainArgsBuilder.() -> Unit): GetAccountsResult {
        val builder = GetAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountsResultToKotlin(getAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Control Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.120.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.resourcemanager.getControlPolicies({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstResourceManagerControlPolicyId = example.then(example => example.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.resourcemanager.get_control_policies(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstResourceManagerControlPolicyId", example.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.ResourceManager.GetControlPolicies.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstResourceManagerControlPolicyId"] = example&#46;Apply(getControlPoliciesResult => getControlPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := resourcemanager.GetControlPolicies(ctx, &resourcemanager.GetControlPoliciesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstResourceManagerControlPolicyId", example.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetControlPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ResourcemanagerFunctions.getControlPolicies(GetControlPoliciesArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstResourceManagerControlPolicyId", example.applyValue(getControlPoliciesResult -> getControlPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getControlPolicies
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstResourceManagerControlPolicyId: ${example.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getControlPolicies.
     * @return A collection of values returned by getControlPolicies.
     */
    public suspend fun getControlPolicies(argument: GetControlPoliciesPlainArgs): GetControlPoliciesResult =
        getControlPoliciesResultToKotlin(getControlPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getControlPolicies].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Control Policy IDs.
     * @param language The language. Valid value `zh-CN`, `en`, and `ja`. Default value `zh-CN`.
     * @param nameRegex A regex string to filter results by Control Policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param policyType The policy type of control policy. Valid values `System` and `Custom`.
     * @return A collection of values returned by getControlPolicies.
     */
    public suspend fun getControlPolicies(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        language: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        policyType: String? = null,
    ): GetControlPoliciesResult {
        val argument = GetControlPoliciesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            language = language,
            nameRegex = nameRegex,
            outputFile = outputFile,
            policyType = policyType,
        )
        return getControlPoliciesResultToKotlin(getControlPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getControlPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetControlPoliciesPlainArgs].
     * @return A collection of values returned by getControlPolicies.
     */
    public suspend fun getControlPolicies(argument: suspend GetControlPoliciesPlainArgsBuilder.() -> Unit): GetControlPoliciesResult {
        val builder = GetControlPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getControlPoliciesResultToKotlin(getControlPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Control Policy Attachments of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.120.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.resourcemanager.getControlPolicyAttachments({
     *     targetId: "example_value",
     * });
     * export const firstResourceManagerControlPolicyAttachmentId = example.then(example => example.attachments?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.resourcemanager.get_control_policy_attachments(target_id="example_value")
     * pulumi.export("firstResourceManagerControlPolicyAttachmentId", example.attachments[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.ResourceManager.GetControlPolicyAttachments.Invoke(new()
     *     {
     *         TargetId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstResourceManagerControlPolicyAttachmentId"] = example&#46;Apply(getControlPolicyAttachmentsResult => getControlPolicyAttachmentsResult&#46;Attachments[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := resourcemanager.GetControlPolicyAttachments(ctx, &resourcemanager.GetControlPolicyAttachmentsArgs{
     * 			TargetId: "example_value",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstResourceManagerControlPolicyAttachmentId", example.Attachments[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetControlPolicyAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ResourcemanagerFunctions.getControlPolicyAttachments(GetControlPolicyAttachmentsArgs.builder()
     *             .targetId("example_value")
     *             .build());
     *         ctx.export("firstResourceManagerControlPolicyAttachmentId", example.applyValue(getControlPolicyAttachmentsResult -> getControlPolicyAttachmentsResult.attachments()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getControlPolicyAttachments
     *       Arguments:
     *         targetId: example_value
     * outputs:
     *   firstResourceManagerControlPolicyAttachmentId: ${example.attachments[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getControlPolicyAttachments.
     * @return A collection of values returned by getControlPolicyAttachments.
     */
    public suspend fun getControlPolicyAttachments(argument: GetControlPolicyAttachmentsPlainArgs): GetControlPolicyAttachmentsResult =
        getControlPolicyAttachmentsResultToKotlin(getControlPolicyAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getControlPolicyAttachments].
     * @param language The language. Valid value `zh-CN`, `en`, and `ja`. Default value `zh-CN`
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param policyType The policy type of control policy. Valid values: `Custom` and `System`.
     * @param targetId The Id of target.
     * @return A collection of values returned by getControlPolicyAttachments.
     */
    public suspend fun getControlPolicyAttachments(
        language: String? = null,
        outputFile: String? = null,
        policyType: String? = null,
        targetId: String,
    ): GetControlPolicyAttachmentsResult {
        val argument = GetControlPolicyAttachmentsPlainArgs(
            language = language,
            outputFile = outputFile,
            policyType = policyType,
            targetId = targetId,
        )
        return getControlPolicyAttachmentsResultToKotlin(getControlPolicyAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getControlPolicyAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetControlPolicyAttachmentsPlainArgs].
     * @return A collection of values returned by getControlPolicyAttachments.
     */
    public suspend fun getControlPolicyAttachments(argument: suspend GetControlPolicyAttachmentsPlainArgsBuilder.() -> Unit): GetControlPolicyAttachmentsResult {
        val builder = GetControlPolicyAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getControlPolicyAttachmentsResultToKotlin(getControlPolicyAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Delegated Administrators of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.181.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.resourcemanager.getDelegatedAdministrators({
     *     ids: ["example_value"],
     * });
     * export const resourceManagerDelegatedAdministratorId1 = ids.then(ids => ids.administrators?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.resourcemanager.get_delegated_administrators(ids=["example_value"])
     * pulumi.export("resourceManagerDelegatedAdministratorId1", ids.administrators[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ResourceManager.GetDelegatedAdministrators.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["resourceManagerDelegatedAdministratorId1"] = ids&#46;Apply(getDelegatedAdministratorsResult => getDelegatedAdministratorsResult&#46;Administrators[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := resourcemanager.GetDelegatedAdministrators(ctx, &resourcemanager.GetDelegatedAdministratorsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("resourceManagerDelegatedAdministratorId1", ids.Administrators[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetDelegatedAdministratorsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ResourcemanagerFunctions.getDelegatedAdministrators(GetDelegatedAdministratorsArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("resourceManagerDelegatedAdministratorId1", ids.applyValue(getDelegatedAdministratorsResult -> getDelegatedAdministratorsResult.administrators()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getDelegatedAdministrators
     *       Arguments:
     *         ids:
     *           - example_value
     * outputs:
     *   resourceManagerDelegatedAdministratorId1: ${ids.administrators[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDelegatedAdministrators.
     * @return A collection of values returned by getDelegatedAdministrators.
     */
    public suspend fun getDelegatedAdministrators(argument: GetDelegatedAdministratorsPlainArgs): GetDelegatedAdministratorsResult =
        getDelegatedAdministratorsResultToKotlin(getDelegatedAdministratorsPlain(argument.toJava()).await())

    /**
     * @see [getDelegatedAdministrators].
     * @param ids A list of Delegated Administrator IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param servicePrincipal The identification of the trusted service.
     * @return A collection of values returned by getDelegatedAdministrators.
     */
    public suspend fun getDelegatedAdministrators(
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        servicePrincipal: String? = null,
    ): GetDelegatedAdministratorsResult {
        val argument = GetDelegatedAdministratorsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            servicePrincipal = servicePrincipal,
        )
        return getDelegatedAdministratorsResultToKotlin(getDelegatedAdministratorsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDelegatedAdministrators].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetDelegatedAdministratorsPlainArgs].
     * @return A collection of values returned by getDelegatedAdministrators.
     */
    public suspend fun getDelegatedAdministrators(argument: suspend GetDelegatedAdministratorsPlainArgsBuilder.() -> Unit): GetDelegatedAdministratorsResult {
        val builder = GetDelegatedAdministratorsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDelegatedAdministratorsResultToKotlin(getDelegatedAdministratorsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the resource manager folders of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.84.0+.
     * > **NOTE:**  You can view only the information of the first-level child folders of the specified folder.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.resourcemanager.getFolders({
     *     nameRegex: "tftest",
     * });
     * export const firstFolderId = example.then(example => example.folders?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.resourcemanager.get_folders(name_regex="tftest")
     * pulumi.export("firstFolderId", example.folders[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.ResourceManager.GetFolders.Invoke(new()
     *     {
     *         NameRegex = "tftest",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstFolderId"] = example&#46;Apply(getFoldersResult => getFoldersResult&#46;Folders[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := resourcemanager.GetFolders(ctx, &resourcemanager.GetFoldersArgs{
     * 			NameRegex: pulumi.StringRef("tftest"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstFolderId", example.Folders[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetFoldersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ResourcemanagerFunctions.getFolders(GetFoldersArgs.builder()
     *             .nameRegex("tftest")
     *             .build());
     *         ctx.export("firstFolderId", example.applyValue(getFoldersResult -> getFoldersResult.folders()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getFolders
     *       Arguments:
     *         nameRegex: tftest
     * outputs:
     *   firstFolderId: ${example.folders[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFolders.
     * @return A collection of values returned by getFolders.
     */
    public suspend fun getFolders(argument: GetFoldersPlainArgs): GetFoldersResult =
        getFoldersResultToKotlin(getFoldersPlain(argument.toJava()).await())

    /**
     * @see [getFolders].
     * @param enableDetails Default to `false`. Set it to true can output more details.
     * @param ids A list of resource manager folders IDs.
     * @param nameRegex A regex string to filter results by folder name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param parentFolderId The ID of the parent folder.
     * @param queryKeyword The query keyword.
     * @return A collection of values returned by getFolders.
     */
    public suspend fun getFolders(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        parentFolderId: String? = null,
        queryKeyword: String? = null,
    ): GetFoldersResult {
        val argument = GetFoldersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            parentFolderId = parentFolderId,
            queryKeyword = queryKeyword,
        )
        return getFoldersResultToKotlin(getFoldersPlain(argument.toJava()).await())
    }

    /**
     * @see [getFolders].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetFoldersPlainArgs].
     * @return A collection of values returned by getFolders.
     */
    public suspend fun getFolders(argument: suspend GetFoldersPlainArgsBuilder.() -> Unit): GetFoldersResult {
        val builder = GetFoldersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFoldersResultToKotlin(getFoldersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Handshakes of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.86.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.resourcemanager.getHandshakes({});
     * export const firstHandshakeId = example.then(example => example.handshakes?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.resourcemanager.get_handshakes()
     * pulumi.export("firstHandshakeId", example.handshakes[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.ResourceManager.GetHandshakes.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstHandshakeId"] = example&#46;Apply(getHandshakesResult => getHandshakesResult&#46;Handshakes[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := resourcemanager.GetHandshakes(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstHandshakeId", example.Handshakes[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetHandshakesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ResourcemanagerFunctions.getHandshakes();
     *         ctx.export("firstHandshakeId", example.applyValue(getHandshakesResult -> getHandshakesResult.handshakes()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getHandshakes
     *       Arguments: {}
     * outputs:
     *   firstHandshakeId: ${example.handshakes[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHandshakes.
     * @return A collection of values returned by getHandshakes.
     */
    public suspend fun getHandshakes(argument: GetHandshakesPlainArgs): GetHandshakesResult =
        getHandshakesResultToKotlin(getHandshakesPlain(argument.toJava()).await())

    /**
     * @see [getHandshakes].
     * @param enableDetails Default to `false`. Set it to true can output more details.
     * @param ids A list of Resource Manager Handshake IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of handshake, valid values: `Accepted`, `Cancelled`, `Declined`, `Deleted`, `Expired` and `Pending`.
     * @return A collection of values returned by getHandshakes.
     */
    public suspend fun getHandshakes(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetHandshakesResult {
        val argument = GetHandshakesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getHandshakesResultToKotlin(getHandshakesPlain(argument.toJava()).await())
    }

    /**
     * @see [getHandshakes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetHandshakesPlainArgs].
     * @return A collection of values returned by getHandshakes.
     */
    public suspend fun getHandshakes(argument: suspend GetHandshakesPlainArgsBuilder.() -> Unit): GetHandshakesResult {
        val builder = GetHandshakesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHandshakesResultToKotlin(getHandshakesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Policies of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.86.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ResourcemanagerFunctions.getPolicies(GetPoliciesArgs.builder()
     *             .nameRegex("tftest")
     *             .descriptionRegex("tftest_policy")
     *             .policyType("Custom")
     *             .build());
     *         ctx.export("firstPolicyId", example.applyValue(getPoliciesResult -> getPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getPolicies
     *       Arguments:
     *         nameRegex: tftest
     *         descriptionRegex: tftest_policy
     *         policyType: Custom
     * outputs:
     *   firstPolicyId: ${example.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPolicies.
     * @return A collection of values returned by getPolicies.
     */
    public suspend fun getPolicies(argument: GetPoliciesPlainArgs): GetPoliciesResult =
        getPoliciesResultToKotlin(getPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getPolicies].
     * @param ids A list of Resource Manager Policy IDs.
     * @param nameRegex A regex string to filter results by policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param policyType The type of the policy. If you do not specify this parameter, the system lists all types of policies. Valid values: `Custom` and `System`.
     * @return A collection of values returned by getPolicies.
     */
    public suspend fun getPolicies(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        policyType: String? = null,
    ): GetPoliciesResult {
        val argument = GetPoliciesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            policyType = policyType,
        )
        return getPoliciesResultToKotlin(getPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetPoliciesPlainArgs].
     * @return A collection of values returned by getPolicies.
     */
    public suspend fun getPolicies(argument: suspend GetPoliciesPlainArgsBuilder.() -> Unit): GetPoliciesResult {
        val builder = GetPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPoliciesResultToKotlin(getPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Policy Attachments of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.93.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.resourcemanager.getPolicyAttachments({});
     * export const firstAttachmentId = example.then(example => example.attachments?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.resourcemanager.get_policy_attachments()
     * pulumi.export("firstAttachmentId", example.attachments[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.ResourceManager.GetPolicyAttachments.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstAttachmentId"] = example&#46;Apply(getPolicyAttachmentsResult => getPolicyAttachmentsResult&#46;Attachments[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := resourcemanager.GetPolicyAttachments(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstAttachmentId", example.Attachments[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetPolicyAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ResourcemanagerFunctions.getPolicyAttachments();
     *         ctx.export("firstAttachmentId", example.applyValue(getPolicyAttachmentsResult -> getPolicyAttachmentsResult.attachments()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getPolicyAttachments
     *       Arguments: {}
     * outputs:
     *   firstAttachmentId: ${example.attachments[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPolicyAttachments.
     * @return A collection of values returned by getPolicyAttachments.
     */
    public suspend fun getPolicyAttachments(argument: GetPolicyAttachmentsPlainArgs): GetPolicyAttachmentsResult =
        getPolicyAttachmentsResultToKotlin(getPolicyAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getPolicyAttachments].
     * @param language The language that is used to return the description of the system policy. Valid values:`en`: English, `zh-CN`: Chinese, `ja`: Japanese.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param policyName The name of the policy. The name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     * @param policyType The type of the policy. Valid values: `Custom` and `System`.
     * @param principalName The name of the object to which the policy is attached.
     * @param principalType The type of the object to which the policy is attached. If you do not specify this parameter, the system lists all types of objects. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
     * @param resourceGroupId The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs. If you do not specify this parameter, the system lists all policy attachment records under the current account.
     * @return A collection of values returned by getPolicyAttachments.
     */
    public suspend fun getPolicyAttachments(
        language: String? = null,
        outputFile: String? = null,
        policyName: String? = null,
        policyType: String? = null,
        principalName: String? = null,
        principalType: String? = null,
        resourceGroupId: String? = null,
    ): GetPolicyAttachmentsResult {
        val argument = GetPolicyAttachmentsPlainArgs(
            language = language,
            outputFile = outputFile,
            policyName = policyName,
            policyType = policyType,
            principalName = principalName,
            principalType = principalType,
            resourceGroupId = resourceGroupId,
        )
        return getPolicyAttachmentsResultToKotlin(getPolicyAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetPolicyAttachmentsPlainArgs].
     * @return A collection of values returned by getPolicyAttachments.
     */
    public suspend fun getPolicyAttachments(argument: suspend GetPolicyAttachmentsPlainArgsBuilder.() -> Unit): GetPolicyAttachmentsResult {
        val builder = GetPolicyAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyAttachmentsResultToKotlin(getPolicyAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Policy Versions of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.85.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.resourcemanager.getPolicyVersions({
     *     policyName: "tftest",
     *     policyType: "Custom",
     * });
     * export const firstPolicyVersionId = _default.then(_default => _default.versions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.resourcemanager.get_policy_versions(policy_name="tftest",
     *     policy_type="Custom")
     * pulumi.export("firstPolicyVersionId", default.versions[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ResourceManager.GetPolicyVersions.Invoke(new()
     *     {
     *         PolicyName = "tftest",
     *         PolicyType = "Custom",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstPolicyVersionId"] = @default&#46;Apply(@default => @default&#46;Apply(getPolicyVersionsResult => getPolicyVersionsResult&#46;Versions[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := resourcemanager.GetPolicyVersions(ctx, &resourcemanager.GetPolicyVersionsArgs{
     * 			PolicyName: "tftest",
     * 			PolicyType: "Custom",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstPolicyVersionId", _default.Versions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetPolicyVersionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ResourcemanagerFunctions.getPolicyVersions(GetPolicyVersionsArgs.builder()
     *             .policyName("tftest")
     *             .policyType("Custom")
     *             .build());
     *         ctx.export("firstPolicyVersionId", default_.versions()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getPolicyVersions
     *       Arguments:
     *         policyName: tftest
     *         policyType: Custom
     * outputs:
     *   firstPolicyVersionId: ${default.versions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPolicyVersions.
     * @return A collection of values returned by getPolicyVersions.
     */
    public suspend fun getPolicyVersions(argument: GetPolicyVersionsPlainArgs): GetPolicyVersionsResult =
        getPolicyVersionsResultToKotlin(getPolicyVersionsPlain(argument.toJava()).await())

    /**
     * @see [getPolicyVersions].
     * @param enableDetails Default to `false`. Set it to true can output more details.
     * @param ids A list of policy version IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param policyName The name of the policy.
     * @param policyType The type of the policy. Valid values:`Custom` and `System`.
     * @return A collection of values returned by getPolicyVersions.
     */
    public suspend fun getPolicyVersions(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        policyName: String,
        policyType: String,
    ): GetPolicyVersionsResult {
        val argument = GetPolicyVersionsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            policyName = policyName,
            policyType = policyType,
        )
        return getPolicyVersionsResultToKotlin(getPolicyVersionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyVersions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetPolicyVersionsPlainArgs].
     * @return A collection of values returned by getPolicyVersions.
     */
    public suspend fun getPolicyVersions(argument: suspend GetPolicyVersionsPlainArgsBuilder.() -> Unit): GetPolicyVersionsResult {
        val builder = GetPolicyVersionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyVersionsResultToKotlin(getPolicyVersionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Resource Directories of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.86.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.resourcemanager.getResourceDirectories({});
     * export const resourceDirectoryId = _default.then(_default => _default.directories?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.resourcemanager.get_resource_directories()
     * pulumi.export("resourceDirectoryId", default.directories[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ResourceManager.GetResourceDirectories.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["resourceDirectoryId"] = @default&#46;Apply(@default => @default&#46;Apply(getResourceDirectoriesResult => getResourceDirectoriesResult&#46;Directories[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := resourcemanager.GetResourceDirectories(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("resourceDirectoryId", _default.Directories[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceDirectoriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ResourcemanagerFunctions.getResourceDirectories();
     *         ctx.export("resourceDirectoryId", default_.directories()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getResourceDirectories
     *       Arguments: {}
     * outputs:
     *   resourceDirectoryId: ${default.directories[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResourceDirectories.
     * @return A collection of values returned by getResourceDirectories.
     */
    public suspend fun getResourceDirectories(argument: GetResourceDirectoriesPlainArgs): GetResourceDirectoriesResult =
        getResourceDirectoriesResultToKotlin(getResourceDirectoriesPlain(argument.toJava()).await())

    /**
     * @see [getResourceDirectories].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getResourceDirectories.
     */
    public suspend fun getResourceDirectories(outputFile: String? = null): GetResourceDirectoriesResult {
        val argument = GetResourceDirectoriesPlainArgs(
            outputFile = outputFile,
        )
        return getResourceDirectoriesResultToKotlin(getResourceDirectoriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceDirectories].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetResourceDirectoriesPlainArgs].
     * @return A collection of values returned by getResourceDirectories.
     */
    public suspend fun getResourceDirectories(argument: suspend GetResourceDirectoriesPlainArgsBuilder.() -> Unit): GetResourceDirectoriesResult {
        val builder = GetResourceDirectoriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceDirectoriesResultToKotlin(getResourceDirectoriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides resource groups of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.84.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.resourcemanager.getResourceGroups({
     *     nameRegex: "tf",
     * });
     * export const firstResourceGroupId = example.then(example => example.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.resourcemanager.get_resource_groups(name_regex="tf")
     * pulumi.export("firstResourceGroupId", example.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
     *     {
     *         NameRegex = "tf",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstResourceGroupId"] = example&#46;Apply(getResourceGroupsResult => getResourceGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
     * 			NameRegex: pulumi.StringRef("tf"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstResourceGroupId", example.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
     *             .nameRegex("tf")
     *             .build());
     *         ctx.export("firstResourceGroupId", example.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getResourceGroups
     *       Arguments:
     *         nameRegex: tf
     * outputs:
     *   firstResourceGroupId: ${example.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResourceGroups.
     * @return A collection of values returned by getResourceGroups.
     */
    public suspend fun getResourceGroups(argument: GetResourceGroupsPlainArgs): GetResourceGroupsResult =
        getResourceGroupsResultToKotlin(getResourceGroupsPlain(argument.toJava()).await())

    /**
     * @see [getResourceGroups].
     * @param enableDetails Set it to true can output more details. Default value: `false`.
     * @param ids A list of resource group IDs.
     * @param nameRegex A regex string to filter results by resource group identifier.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource group. Valid values: `Creating`, `Deleted`, `Deleting`, `OK` and `PendingDelete`. **NOTE:** From version 1.114.0, `status` can be set to `Deleting`.
     * @return A collection of values returned by getResourceGroups.
     */
    public suspend fun getResourceGroups(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetResourceGroupsResult {
        val argument = GetResourceGroupsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getResourceGroupsResultToKotlin(getResourceGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetResourceGroupsPlainArgs].
     * @return A collection of values returned by getResourceGroups.
     */
    public suspend fun getResourceGroups(argument: suspend GetResourceGroupsPlainArgsBuilder.() -> Unit): GetResourceGroupsResult {
        val builder = GetResourceGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceGroupsResultToKotlin(getResourceGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Resource Shares of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.111.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.resourcemanager.getResourceShares({
     *     resourceShareOwner: "Self",
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstResourceManagerResourceShareId = example.then(example => example.shares?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.resourcemanager.get_resource_shares(resource_share_owner="Self",
     *     ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstResourceManagerResourceShareId", example.shares[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.ResourceManager.GetResourceShares.Invoke(new()
     *     {
     *         ResourceShareOwner = "Self",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstResourceManagerResourceShareId"] = example&#46;Apply(getResourceSharesResult => getResourceSharesResult&#46;Shares[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := resourcemanager.GetResourceShares(ctx, &resourcemanager.GetResourceSharesArgs{
     * 			ResourceShareOwner: "Self",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstResourceManagerResourceShareId", example.Shares[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceSharesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ResourcemanagerFunctions.getResourceShares(GetResourceSharesArgs.builder()
     *             .resourceShareOwner("Self")
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstResourceManagerResourceShareId", example.applyValue(getResourceSharesResult -> getResourceSharesResult.shares()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getResourceShares
     *       Arguments:
     *         resourceShareOwner: Self
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstResourceManagerResourceShareId: ${example.shares[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResourceShares.
     * @return A collection of values returned by getResourceShares.
     */
    public suspend fun getResourceShares(argument: GetResourceSharesPlainArgs): GetResourceSharesResult =
        getResourceSharesResultToKotlin(getResourceSharesPlain(argument.toJava()).await())

    /**
     * @see [getResourceShares].
     * @param ids A list of Resource Share IDs.
     * @param nameRegex A regex string to filter results by Resource Share name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceShareName The name of resource share.
     * @param resourceShareOwner The owner of resource share, Valid values: `Self` and `OtherAccounts`.
     * @param status The status of resource share. Valid values: `Active`,`Deleted` and `Deleting`.
     * @return A collection of values returned by getResourceShares.
     */
    public suspend fun getResourceShares(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceShareName: String? = null,
        resourceShareOwner: String,
        status: String? = null,
    ): GetResourceSharesResult {
        val argument = GetResourceSharesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceShareName = resourceShareName,
            resourceShareOwner = resourceShareOwner,
            status = status,
        )
        return getResourceSharesResultToKotlin(getResourceSharesPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceShares].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetResourceSharesPlainArgs].
     * @return A collection of values returned by getResourceShares.
     */
    public suspend fun getResourceShares(argument: suspend GetResourceSharesPlainArgsBuilder.() -> Unit): GetResourceSharesResult {
        val builder = GetResourceSharesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceSharesResultToKotlin(getResourceSharesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Roles of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.86.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.resourcemanager.getRoles({
     *     nameRegex: "tftest",
     * });
     * export const firstRoleId = example.then(example => example.roles?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.resourcemanager.get_roles(name_regex="tftest")
     * pulumi.export("firstRoleId", example.roles[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.ResourceManager.GetRoles.Invoke(new()
     *     {
     *         NameRegex = "tftest",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRoleId"] = example&#46;Apply(getRolesResult => getRolesResult&#46;Roles[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := resourcemanager.GetRoles(ctx, &resourcemanager.GetRolesArgs{
     * 			NameRegex: pulumi.StringRef("tftest"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRoleId", example.Roles[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ResourcemanagerFunctions.getRoles(GetRolesArgs.builder()
     *             .nameRegex("tftest")
     *             .build());
     *         ctx.export("firstRoleId", example.applyValue(getRolesResult -> getRolesResult.roles()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getRoles
     *       Arguments:
     *         nameRegex: tftest
     * outputs:
     *   firstRoleId: ${example.roles[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRoles.
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(argument: GetRolesPlainArgs): GetRolesResult =
        getRolesResultToKotlin(getRolesPlain(argument.toJava()).await())

    /**
     * @see [getRoles].
     * @param enableDetails Default to `false`. Set it to true can output more details.
     * @param ids A list of Resource Manager Role IDs.
     * @param nameRegex A regex string to filter results by role name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetRolesResult {
        val argument = GetRolesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getRolesResultToKotlin(getRolesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRoles].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetRolesPlainArgs].
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(argument: suspend GetRolesPlainArgsBuilder.() -> Unit): GetRolesResult {
        val builder = GetRolesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRolesResultToKotlin(getRolesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Shared Resources of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.111.0.
     * @param argument A collection of arguments for invoking getSharedResources.
     * @return A collection of values returned by getSharedResources.
     */
    public suspend fun getSharedResources(argument: GetSharedResourcesPlainArgs): GetSharedResourcesResult =
        getSharedResourcesResultToKotlin(getSharedResourcesPlain(argument.toJava()).await())

    /**
     * @see [getSharedResources].
     * @param ids A list of shared resource IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceShareId The resource share ID of resource manager.
     * @param status The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
     * @return A collection of values returned by getSharedResources.
     */
    public suspend fun getSharedResources(
        ids: List<String>? = null,
        outputFile: String? = null,
        resourceShareId: String? = null,
        status: String? = null,
    ): GetSharedResourcesResult {
        val argument = GetSharedResourcesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            resourceShareId = resourceShareId,
            status = status,
        )
        return getSharedResourcesResultToKotlin(getSharedResourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSharedResources].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetSharedResourcesPlainArgs].
     * @return A collection of values returned by getSharedResources.
     */
    public suspend fun getSharedResources(argument: suspend GetSharedResourcesPlainArgsBuilder.() -> Unit): GetSharedResourcesResult {
        val builder = GetSharedResourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSharedResourcesResultToKotlin(getSharedResourcesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Resource Manager Shared Targets of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.111.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "tf-example";
     * const default = alicloud.resourcemanager.getAccounts({});
     * const defaultResourceShare = new alicloud.resourcemanager.ResourceShare("default", {resourceShareName: name});
     * const defaultSharedTarget = new alicloud.resourcemanager.SharedTarget("default", {
     *     resourceShareId: defaultResourceShare.id,
     *     targetId: _default.then(_default => _default.ids?.[0]),
     * });
     * const ids = alicloud.resourcemanager.getSharedTargetsOutput({
     *     ids: [defaultSharedTarget&#46;targetId],
     * });
     * export const firstResourceManagerSharedTargetId = ids.apply(ids => ids.targets?.[0]?.id);
     * const resourceShareId = alicloud.resourcemanager.getSharedTargetsOutput({
     *     resourceShareId: defaultSharedTarget.resourceShareId,
     * });
     * export const secondResourceManagerSharedTargetId = resourceShareId.apply(resourceShareId => resourceShareId.targets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "tf-example"
     * default = alicloud.resourcemanager.get_accounts()
     * default_resource_share = alicloud.resourcemanager.ResourceShare("default", resource_share_name=name)
     * default_shared_target = alicloud.resourcemanager.SharedTarget("default",
     *     resource_share_id=default_resource_share.id,
     *     target_id=default.ids[0])
     * ids = alicloud.resourcemanager.get_shared_targets_output(ids=[default_shared_target&#46;target_id])
     * pulumi.export("firstResourceManagerSharedTargetId", ids.targets[0].id)
     * resource_share_id = alicloud.resourcemanager.get_shared_targets_output(resource_share_id=default_shared_target.resource_share_id)
     * pulumi.export("secondResourceManagerSharedTargetId", resource_share_id.targets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "tf-example";
     *     var @default = AliCloud.ResourceManager.GetAccounts.Invoke();
     *     var defaultResourceShare = new AliCloud.ResourceManager.ResourceShare("default", new()
     *     {
     *         ResourceShareName = name,
     *     });
     *     var defaultSharedTarget = new AliCloud.ResourceManager.SharedTarget("default", new()
     *     {
     *         ResourceShareId = defaultResourceShare.Id,
     *         TargetId = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Ids[0])),
     *     });
     *     var ids = AliCloud.ResourceManager.GetSharedTargets.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultSharedTarget.TargetId,
     *         },
     *     });
     *     var resourceShareId = AliCloud.ResourceManager.GetSharedTargets.Invoke(new()
     *     {
     *         ResourceShareId = defaultSharedTarget.ResourceShareId,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstResourceManagerSharedTargetId"] = ids&#46;Apply(getSharedTargetsResult => getSharedTargetsResult&#46;Targets[0]?.Id),
     *         ["secondResourceManagerSharedTargetId"] = resourceShareId&#46;Apply(getSharedTargetsResult => getSharedTargetsResult&#46;Targets[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "tf-example"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := resourcemanager.GetAccounts(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultResourceShare, err := resourcemanager.NewResourceShare(ctx, "default", &resourcemanager.ResourceShareArgs{
     * 			ResourceShareName: pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultSharedTarget, err := resourcemanager.NewSharedTarget(ctx, "default", &resourcemanager.SharedTargetArgs{
     * 			ResourceShareId: defaultResourceShare.ID(),
     * 			TargetId:        pulumi.String(_default.Ids[0]),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := resourcemanager.GetSharedTargetsOutput(ctx, resourcemanager.GetSharedTargetsOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultSharedTarget.TargetId,
     * 			},
     * 		}, nil)
     * 		ctx.Export("firstResourceManagerSharedTargetId", ids.ApplyT(func(ids resourcemanager.GetSharedTargetsResult) (*string, error) {
     * 			return &ids.Targets[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		resourceShareId := resourcemanager.GetSharedTargetsOutput(ctx, resourcemanager.GetSharedTargetsOutputArgs{
     * 			ResourceShareId: defaultSharedTarget.ResourceShareId,
     * 		}, nil)
     * 		ctx.Export("secondResourceManagerSharedTargetId", resourceShareId.ApplyT(func(resourceShareId resourcemanager.GetSharedTargetsResult) (*string, error) {
     * 			return &resourceShareId.Targets[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetAccountsArgs;
     * import com.pulumi.alicloud.resourcemanager.ResourceShare;
     * import com.pulumi.alicloud.resourcemanager.ResourceShareArgs;
     * import com.pulumi.alicloud.resourcemanager.SharedTarget;
     * import com.pulumi.alicloud.resourcemanager.SharedTargetArgs;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetSharedTargetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("tf-example");
     *         final var default = ResourcemanagerFunctions.getAccounts();
     *         var defaultResourceShare = new ResourceShare("defaultResourceShare", ResourceShareArgs.builder()
     *             .resourceShareName(name)
     *             .build());
     *         var defaultSharedTarget = new SharedTarget("defaultSharedTarget", SharedTargetArgs.builder()
     *             .resourceShareId(defaultResourceShare.id())
     *             .targetId(default_.ids()[0])
     *             .build());
     *         final var ids = ResourcemanagerFunctions.getSharedTargets(GetSharedTargetsArgs.builder()
     *             .ids(defaultSharedTarget.targetId())
     *             .build());
     *         ctx.export("firstResourceManagerSharedTargetId", ids.applyValue(getSharedTargetsResult -> getSharedTargetsResult).applyValue(ids -> ids.applyValue(getSharedTargetsResult -> getSharedTargetsResult.targets()[0].id())));
     *         final var resourceShareId = ResourcemanagerFunctions.getSharedTargets(GetSharedTargetsArgs.builder()
     *             .resourceShareId(defaultSharedTarget.resourceShareId())
     *             .build());
     *         ctx.export("secondResourceManagerSharedTargetId", resourceShareId.applyValue(getSharedTargetsResult -> getSharedTargetsResult).applyValue(resourceShareId -> resourceShareId.applyValue(getSharedTargetsResult -> getSharedTargetsResult.targets()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: tf-example
     * resources:
     *   defaultResourceShare:
     *     type: alicloud:resourcemanager:ResourceShare
     *     name: default
     *     properties:
     *       resourceShareName: ${name}
     *   defaultSharedTarget:
     *     type: alicloud:resourcemanager:SharedTarget
     *     name: default
     *     properties:
     *       resourceShareId: ${defaultResourceShare.id}
     *       targetId: ${default.ids[0]}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getAccounts
     *       Arguments: {}
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getSharedTargets
     *       Arguments:
     *         ids:
     *           - ${defaultSharedTarget.targetId}
     *   resourceShareId:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getSharedTargets
     *       Arguments:
     *         resourceShareId: ${defaultSharedTarget.resourceShareId}
     * outputs:
     *   firstResourceManagerSharedTargetId: ${ids.targets[0].id}
     *   secondResourceManagerSharedTargetId: ${resourceShareId.targets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSharedTargets.
     * @return A collection of values returned by getSharedTargets.
     */
    public suspend fun getSharedTargets(argument: GetSharedTargetsPlainArgs): GetSharedTargetsResult =
        getSharedTargetsResultToKotlin(getSharedTargetsPlain(argument.toJava()).await())

    /**
     * @see [getSharedTargets].
     * @param ids A list of Shared Target IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceShareId The resource share ID of resource manager.
     * @param status The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
     * @return A collection of values returned by getSharedTargets.
     */
    public suspend fun getSharedTargets(
        ids: List<String>? = null,
        outputFile: String? = null,
        resourceShareId: String? = null,
        status: String? = null,
    ): GetSharedTargetsResult {
        val argument = GetSharedTargetsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            resourceShareId = resourceShareId,
            status = status,
        )
        return getSharedTargetsResultToKotlin(getSharedTargetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSharedTargets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;resourcemanager&#46;kotlin&#46;inputs&#46;GetSharedTargetsPlainArgs].
     * @return A collection of values returned by getSharedTargets.
     */
    public suspend fun getSharedTargets(argument: suspend GetSharedTargetsPlainArgsBuilder.() -> Unit): GetSharedTargetsResult {
        val builder = GetSharedTargetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSharedTargetsResultToKotlin(getSharedTargetsPlain(builtArgument.toJava()).await())
    }
}
