@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Role].
 */
@PulumiTagMarker
public class RoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleArgs = RoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleArgsBuilder.() -> Unit) {
        val builder = RoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Role {
        val builtJavaResource = com.pulumi.alicloud.resourcemanager.Role(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Role(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager role resource. Members are resource containers in the resource directory, which can physically isolate resources to form an independent resource grouping unit. You can create members in the resource folder to manage them in a unified manner.
 * For information about Resource Manager role and how to use it, see [What is Resource Manager role](https://www.alibabacloud.com/help/en/doc-detail/111231.htm).
 * > **NOTE:** Available since v1.82.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const default = alicloud.getAccount({});
 * const example = new alicloud.resourcemanager.Role("example", {
 *     roleName: name,
 *     assumeRolePolicyDocument: _default.then(_default => `     {
 *           "Statement": [
 *                {
 *                     "Action": "sts:AssumeRole",
 *                     "Effect": "Allow",
 *                     "Principal": {
 *                         "RAM":[
 *                                 "acs:ram::${_default.id}:root"
 *                         ]
 *                     }
 *                 }
 *           ],
 *           "Version": "1"
 *      }
 * `),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.get_account()
 * example = alicloud.resourcemanager.Role("example",
 *     role_name=name,
 *     assume_role_policy_document=f"""     {{
 *           "Statement": [
 *                {{
 *                     "Action": "sts:AssumeRole",
 *                     "Effect": "Allow",
 *                     "Principal": {{
 *                         "RAM":[
 *                                 "acs:ram::{default.id}:root"
 *                         ]
 *                     }}
 *                 }}
 *           ],
 *           "Version": "1"
 *      }}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var example = new AliCloud.ResourceManager.Role("example", new()
 *     {
 *         RoleName = name,
 *         AssumeRolePolicyDocument = @default.Apply(@default => @$"     {{
 *           ""Statement"": [
 *                {{
 *                     ""Action"": ""sts:AssumeRole"",
 *                     ""Effect"": ""Allow"",
 *                     ""Principal"": {{
 *                         ""RAM"":[
 *                                 ""acs:ram::{@default.Apply(getAccountResult => getAccountResult.Id)}:root""
 *                         ]
 *                     }}
 *                 }}
 *           ],
 *           ""Version"": ""1""
 *      }}
 * "),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewRole(ctx, "example", &resourcemanager.RoleArgs{
 * 			RoleName: pulumi.String(name),
 * 			AssumeRolePolicyDocument: pulumi.Sprintf(`     {
 *           "Statement": [
 *                {
 *                     "Action": "sts:AssumeRole",
 *                     "Effect": "Allow",
 *                     "Principal": {
 *                         "RAM":[
 *                                 "acs:ram::%v:root"
 *                         ]
 *                     }
 *                 }
 *           ],
 *           "Version": "1"
 *      }
 * `, _default.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.resourcemanager.Role;
 * import com.pulumi.alicloud.resourcemanager.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         final var default = AlicloudFunctions.getAccount();
 *         var example = new Role("example", RoleArgs.builder()
 *             .roleName(name)
 *             .assumeRolePolicyDocument("""
 *      {
 *           "Statement": [
 *                {
 *                     "Action": "sts:AssumeRole",
 *                     "Effect": "Allow",
 *                     "Principal": {
 *                         "RAM":[
 *                                 "acs:ram::%s:root"
 *                         ]
 *                     }
 *                 }
 *           ],
 *           "Version": "1"
 *      }
 * ", default_.id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:Role
 *     properties:
 *       roleName: ${name}
 *       assumeRolePolicyDocument: |2
 *              {
 *                   "Statement": [
 *                        {
 *                             "Action": "sts:AssumeRole",
 *                             "Effect": "Allow",
 *                             "Principal": {
 *                                 "RAM":[
 *                                         "acs:ram::${default.id}:root"
 *                                 ]
 *                             }
 *                         }
 *                   ],
 *                   "Version": "1"
 *              }
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager can be imported using the id or role_name, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/role:Role example testrd
 * ```
 */
public class Role internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.Role,
) : KotlinCustomResource(javaResource, RoleMapper) {
    /**
     * The resource descriptor of the role.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The content of the permissions strategy that plays a role.
     */
    public val assumeRolePolicyDocument: Output<String>
        get() = javaResource.assumeRolePolicyDocument().applyValue({ args0 -> args0 })

    /**
     * The description of the Resource Manager role.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Role maximum session time. Valid values: [3600-43200]. Default to `3600`.
     */
    public val maxSessionDuration: Output<Int>?
        get() = javaResource.maxSessionDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This ID of Resource Manager role. The value is set to `role_name`.
     */
    public val roleId: Output<String>
        get() = javaResource.roleId().applyValue({ args0 -> args0 })

    /**
     * Role Name. The length is 1 ~ 64 characters, which can include English letters, numbers, dots "." and dashes "-".
     */
    public val roleName: Output<String>
        get() = javaResource.roleName().applyValue({ args0 -> args0 })

    /**
     * Role update time.
     */
    public val updateDate: Output<String>
        get() = javaResource.updateDate().applyValue({ args0 -> args0 })
}

public object RoleMapper : ResourceMapper<Role> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.Role::class == javaResource::class

    override fun map(javaResource: Resource): Role = Role(
        javaResource as
            com.pulumi.alicloud.resourcemanager.Role,
    )
}

/**
 * @see [Role].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Role].
 */
public suspend fun role(name: String, block: suspend RoleResourceBuilder.() -> Unit): Role {
    val builder = RoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Role].
 * @param name The _unique_ name of the resulting resource.
 */
public fun role(name: String): Role {
    val builder = RoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
