@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.RoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager role resource. Members are resource containers in the resource directory, which can physically isolate resources to form an independent resource grouping unit. You can create members in the resource folder to manage them in a unified manner.
 * For information about Resource Manager role and how to use it, see [What is Resource Manager role](https://www.alibabacloud.com/help/en/doc-detail/111231.htm).
 * > **NOTE:** Available since v1.82.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const default = alicloud.getAccount({});
 * const example = new alicloud.resourcemanager.Role("example", {
 *     roleName: name,
 *     assumeRolePolicyDocument: _default.then(_default => `     {
 *           "Statement": [
 *                {
 *                     "Action": "sts:AssumeRole",
 *                     "Effect": "Allow",
 *                     "Principal": {
 *                         "RAM":[
 *                                 "acs:ram::${_default.id}:root"
 *                         ]
 *                     }
 *                 }
 *           ],
 *           "Version": "1"
 *      }
 * `),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.get_account()
 * example = alicloud.resourcemanager.Role("example",
 *     role_name=name,
 *     assume_role_policy_document=f"""     {{
 *           "Statement": [
 *                {{
 *                     "Action": "sts:AssumeRole",
 *                     "Effect": "Allow",
 *                     "Principal": {{
 *                         "RAM":[
 *                                 "acs:ram::{default.id}:root"
 *                         ]
 *                     }}
 *                 }}
 *           ],
 *           "Version": "1"
 *      }}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var example = new AliCloud.ResourceManager.Role("example", new()
 *     {
 *         RoleName = name,
 *         AssumeRolePolicyDocument = @default.Apply(@default => @$"     {{
 *           ""Statement"": [
 *                {{
 *                     ""Action"": ""sts:AssumeRole"",
 *                     ""Effect"": ""Allow"",
 *                     ""Principal"": {{
 *                         ""RAM"":[
 *                                 ""acs:ram::{@default.Apply(getAccountResult => getAccountResult.Id)}:root""
 *                         ]
 *                     }}
 *                 }}
 *           ],
 *           ""Version"": ""1""
 *      }}
 * "),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewRole(ctx, "example", &resourcemanager.RoleArgs{
 * 			RoleName: pulumi.String(name),
 * 			AssumeRolePolicyDocument: pulumi.Sprintf(`     {
 *           "Statement": [
 *                {
 *                     "Action": "sts:AssumeRole",
 *                     "Effect": "Allow",
 *                     "Principal": {
 *                         "RAM":[
 *                                 "acs:ram::%v:root"
 *                         ]
 *                     }
 *                 }
 *           ],
 *           "Version": "1"
 *      }
 * `, _default.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.resourcemanager.Role;
 * import com.pulumi.alicloud.resourcemanager.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         final var default = AlicloudFunctions.getAccount();
 *         var example = new Role("example", RoleArgs.builder()
 *             .roleName(name)
 *             .assumeRolePolicyDocument("""
 *      {
 *           "Statement": [
 *                {
 *                     "Action": "sts:AssumeRole",
 *                     "Effect": "Allow",
 *                     "Principal": {
 *                         "RAM":[
 *                                 "acs:ram::%s:root"
 *                         ]
 *                     }
 *                 }
 *           ],
 *           "Version": "1"
 *      }
 * ", default_.id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:Role
 *     properties:
 *       roleName: ${name}
 *       assumeRolePolicyDocument: |2
 *              {
 *                   "Statement": [
 *                        {
 *                             "Action": "sts:AssumeRole",
 *                             "Effect": "Allow",
 *                             "Principal": {
 *                                 "RAM":[
 *                                         "acs:ram::${default.id}:root"
 *                                 ]
 *                             }
 *                         }
 *                   ],
 *                   "Version": "1"
 *              }
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager can be imported using the id or role_name, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/role:Role example testrd
 * ```
 * @property assumeRolePolicyDocument The content of the permissions strategy that plays a role.
 * @property description The description of the Resource Manager role.
 * @property maxSessionDuration Role maximum session time. Valid values: [3600-43200]. Default to `3600`.
 * @property roleName Role Name. The length is 1 ~ 64 characters, which can include English letters, numbers, dots "." and dashes "-".
 */
public data class RoleArgs(
    public val assumeRolePolicyDocument: Output<String>? = null,
    public val description: Output<String>? = null,
    public val maxSessionDuration: Output<Int>? = null,
    public val roleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.RoleArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.RoleArgs =
        com.pulumi.alicloud.resourcemanager.RoleArgs.builder()
            .assumeRolePolicyDocument(assumeRolePolicyDocument?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .maxSessionDuration(maxSessionDuration?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleArgs].
 */
@PulumiTagMarker
public class RoleArgsBuilder internal constructor() {
    private var assumeRolePolicyDocument: Output<String>? = null

    private var description: Output<String>? = null

    private var maxSessionDuration: Output<Int>? = null

    private var roleName: Output<String>? = null

    /**
     * @param value The content of the permissions strategy that plays a role.
     */
    @JvmName("ohprpkgkhsowkxyy")
    public suspend fun assumeRolePolicyDocument(`value`: Output<String>) {
        this.assumeRolePolicyDocument = value
    }

    /**
     * @param value The description of the Resource Manager role.
     */
    @JvmName("gaqpbeqwupnjdknq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Role maximum session time. Valid values: [3600-43200]. Default to `3600`.
     */
    @JvmName("qcmwaoyhipawuphw")
    public suspend fun maxSessionDuration(`value`: Output<Int>) {
        this.maxSessionDuration = value
    }

    /**
     * @param value Role Name. The length is 1 ~ 64 characters, which can include English letters, numbers, dots "." and dashes "-".
     */
    @JvmName("gmicduvoaiylshtc")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The content of the permissions strategy that plays a role.
     */
    @JvmName("rnyusyhbnhihqlpu")
    public suspend fun assumeRolePolicyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assumeRolePolicyDocument = mapped
    }

    /**
     * @param value The description of the Resource Manager role.
     */
    @JvmName("befigcsmrpdxdbuo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Role maximum session time. Valid values: [3600-43200]. Default to `3600`.
     */
    @JvmName("ooarggktkxpbxwme")
    public suspend fun maxSessionDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSessionDuration = mapped
    }

    /**
     * @param value Role Name. The length is 1 ~ 64 characters, which can include English letters, numbers, dots "." and dashes "-".
     */
    @JvmName("xwguoshbmfklusma")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    internal fun build(): RoleArgs = RoleArgs(
        assumeRolePolicyDocument = assumeRolePolicyDocument,
        description = description,
        maxSessionDuration = maxSessionDuration,
        roleName = roleName,
    )
}
