@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SavedQuery].
 */
@PulumiTagMarker
public class SavedQueryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SavedQueryArgs = SavedQueryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SavedQueryArgsBuilder.() -> Unit) {
        val builder = SavedQueryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SavedQuery {
        val builtJavaResource = com.pulumi.alicloud.resourcemanager.SavedQuery(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SavedQuery(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager Saved Query resource. ResourceCenter Saved Query.
 * For information about Resource Manager Saved Query and how to use it, see [What is Saved Query](https://www.alibabacloud.com/help/zh/resource-management/developer-reference/api-resourcecenter-2022-12-01-createsavedquery).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.resourcemanager.SavedQuery("default", {
 *     description: name,
 *     expression: "select * from resources limit 1;",
 *     savedQueryName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.resourcemanager.SavedQuery("default",
 *     description=name,
 *     expression="select * from resources limit 1;",
 *     saved_query_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ResourceManager.SavedQuery("default", new()
 *     {
 *         Description = name,
 *         Expression = "select * from resources limit 1;",
 *         SavedQueryName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewSavedQuery(ctx, "default", &resourcemanager.SavedQueryArgs{
 * 			Description:    pulumi.String(name),
 * 			Expression:     pulumi.String("select * from resources limit 1;"),
 * 			SavedQueryName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.SavedQuery;
 * import com.pulumi.alicloud.resourcemanager.SavedQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new SavedQuery("default", SavedQueryArgs.builder()
 *             .description(name)
 *             .expression("select * from resources limit 1;")
 *             .savedQueryName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:resourcemanager:SavedQuery
 *     properties:
 *       description: ${name}
 *       expression: select * from resources limit 1;
 *       savedQueryName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Saved Query can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/savedQuery:SavedQuery example <id>
 * ```
 */
public class SavedQuery internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.SavedQuery,
) : KotlinCustomResource(javaResource, SavedQueryMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Query Description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Query Expression.
     */
    public val expression: Output<String>
        get() = javaResource.expression().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val savedQueryName: Output<String>
        get() = javaResource.savedQueryName().applyValue({ args0 -> args0 })
}

public object SavedQueryMapper : ResourceMapper<SavedQuery> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.SavedQuery::class == javaResource::class

    override fun map(javaResource: Resource): SavedQuery = SavedQuery(
        javaResource as
            com.pulumi.alicloud.resourcemanager.SavedQuery,
    )
}

/**
 * @see [SavedQuery].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SavedQuery].
 */
public suspend fun savedQuery(name: String, block: suspend SavedQueryResourceBuilder.() -> Unit): SavedQuery {
    val builder = SavedQueryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SavedQuery].
 * @param name The _unique_ name of the resulting resource.
 */
public fun savedQuery(name: String): SavedQuery {
    val builder = SavedQueryResourceBuilder()
    builder.name(name)
    return builder.build()
}
