@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.SavedQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Saved Query resource. ResourceCenter Saved Query.
 * For information about Resource Manager Saved Query and how to use it, see [What is Saved Query](https://www.alibabacloud.com/help/zh/resource-management/developer-reference/api-resourcecenter-2022-12-01-createsavedquery).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.resourcemanager.SavedQuery("default", {
 *     description: name,
 *     expression: "select * from resources limit 1;",
 *     savedQueryName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.resourcemanager.SavedQuery("default",
 *     description=name,
 *     expression="select * from resources limit 1;",
 *     saved_query_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ResourceManager.SavedQuery("default", new()
 *     {
 *         Description = name,
 *         Expression = "select * from resources limit 1;",
 *         SavedQueryName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewSavedQuery(ctx, "default", &resourcemanager.SavedQueryArgs{
 * 			Description:    pulumi.String(name),
 * 			Expression:     pulumi.String("select * from resources limit 1;"),
 * 			SavedQueryName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.SavedQuery;
 * import com.pulumi.alicloud.resourcemanager.SavedQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new SavedQuery("default", SavedQueryArgs.builder()
 *             .description(name)
 *             .expression("select * from resources limit 1;")
 *             .savedQueryName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:resourcemanager:SavedQuery
 *     properties:
 *       description: ${name}
 *       expression: select * from resources limit 1;
 *       savedQueryName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Saved Query can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/savedQuery:SavedQuery example <id>
 * ```
 * @property description Query Description.
 * @property expression Query Expression.
 * @property savedQueryName The name of the resource.
 */
public data class SavedQueryArgs(
    public val description: Output<String>? = null,
    public val expression: Output<String>? = null,
    public val savedQueryName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.SavedQueryArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.SavedQueryArgs =
        com.pulumi.alicloud.resourcemanager.SavedQueryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .expression(expression?.applyValue({ args0 -> args0 }))
            .savedQueryName(savedQueryName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SavedQueryArgs].
 */
@PulumiTagMarker
public class SavedQueryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var expression: Output<String>? = null

    private var savedQueryName: Output<String>? = null

    /**
     * @param value Query Description.
     */
    @JvmName("nedsshqfxbpvtaqt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Query Expression.
     */
    @JvmName("glsdrgpinhjlyexn")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("npsstlucuidwiavr")
    public suspend fun savedQueryName(`value`: Output<String>) {
        this.savedQueryName = value
    }

    /**
     * @param value Query Description.
     */
    @JvmName("ugmpbubiyjnteehb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Query Expression.
     */
    @JvmName("axdntibkkfedlcpi")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("yupojhodkgfosbhw")
    public suspend fun savedQueryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.savedQueryName = mapped
    }

    internal fun build(): SavedQueryArgs = SavedQueryArgs(
        description = description,
        expression = expression,
        savedQueryName = savedQueryName,
    )
}
