@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceLinkedRole].
 */
@PulumiTagMarker
public class ServiceLinkedRoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceLinkedRoleArgs = ServiceLinkedRoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceLinkedRoleArgsBuilder.() -> Unit) {
        val builder = ServiceLinkedRoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceLinkedRole {
        val builtJavaResource =
            com.pulumi.alicloud.resourcemanager.ServiceLinkedRole(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceLinkedRole(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager Service Linked Role.
 * For information about Resource Manager Service Linked Role and how to use it, see [What is Service Linked Role&#46;](https://www.alibabacloud.com/help/en/doc-detail/171226.htm).
 * > **NOTE:** Available since v1.157.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.resourcemanager.ServiceLinkedRole("default", {serviceName: "ops.elasticsearch.aliyuncs.com"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.ServiceLinkedRole("default", service_name="ops.elasticsearch.aliyuncs.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ResourceManager.ServiceLinkedRole("default", new()
 *     {
 *         ServiceName = "ops.elasticsearch.aliyuncs.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resourcemanager.NewServiceLinkedRole(ctx, "default", &resourcemanager.ServiceLinkedRoleArgs{
 * 			ServiceName: pulumi.String("ops.elasticsearch.aliyuncs.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ServiceLinkedRole;
 * import com.pulumi.alicloud.resourcemanager.ServiceLinkedRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new ServiceLinkedRole("default", ServiceLinkedRoleArgs.builder()
 *             .serviceName("ops.elasticsearch.aliyuncs.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:resourcemanager:ServiceLinkedRole
 *     properties:
 *       serviceName: ops.elasticsearch.aliyuncs.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Service Linked Role can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/serviceLinkedRole:ServiceLinkedRole default <service_name>:<role_name>
 * ```
 */
public class ServiceLinkedRole internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.ServiceLinkedRole,
) : KotlinCustomResource(javaResource, ServiceLinkedRoleMapper) {
    /**
     * The Alibaba Cloud Resource Name (ARN) of the role.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The suffix of the role name. Only a few service linked roles support custom suffixes. The role name (including its suffix) must be 1 to 64 characters in length and can contain letters, digits, periods (.), and hyphens (-). For example, if the suffix is Example, the role name is ServiceLinkedRoleName_Example.
     */
    public val customSuffix: Output<String>?
        get() = javaResource.customSuffix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the service linked role.  This parameter must be specified for only the service linked roles that support custom suffixes. Otherwise, the preset value is used and cannot be modified. The description must be 1 to 1,024 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the role.
     */
    public val roleId: Output<String>
        get() = javaResource.roleId().applyValue({ args0 -> args0 })

    /**
     * The name of the role.
     */
    public val roleName: Output<String>
        get() = javaResource.roleName().applyValue({ args0 -> args0 })

    /**
     * The service name. For more information about the service name, see [Cloud services that support service linked roles](https://www.alibabacloud.com/help/en/doc-detail/160674.htm)
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })
}

public object ServiceLinkedRoleMapper : ResourceMapper<ServiceLinkedRole> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.ServiceLinkedRole::class == javaResource::class

    override fun map(javaResource: Resource): ServiceLinkedRole = ServiceLinkedRole(
        javaResource as
            com.pulumi.alicloud.resourcemanager.ServiceLinkedRole,
    )
}

/**
 * @see [ServiceLinkedRole].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceLinkedRole].
 */
public suspend fun serviceLinkedRole(
    name: String,
    block: suspend ServiceLinkedRoleResourceBuilder.() -> Unit,
): ServiceLinkedRole {
    val builder = ServiceLinkedRoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceLinkedRole].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceLinkedRole(name: String): ServiceLinkedRole {
    val builder = ServiceLinkedRoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
