@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.ServiceLinkedRoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Service Linked Role.
 * For information about Resource Manager Service Linked Role and how to use it, see [What is Service Linked Role&#46;](https://www.alibabacloud.com/help/en/doc-detail/171226.htm).
 * > **NOTE:** Available since v1.157.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.resourcemanager.ServiceLinkedRole("default", {serviceName: "ops.elasticsearch.aliyuncs.com"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.ServiceLinkedRole("default", service_name="ops.elasticsearch.aliyuncs.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ResourceManager.ServiceLinkedRole("default", new()
 *     {
 *         ServiceName = "ops.elasticsearch.aliyuncs.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resourcemanager.NewServiceLinkedRole(ctx, "default", &resourcemanager.ServiceLinkedRoleArgs{
 * 			ServiceName: pulumi.String("ops.elasticsearch.aliyuncs.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ServiceLinkedRole;
 * import com.pulumi.alicloud.resourcemanager.ServiceLinkedRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new ServiceLinkedRole("default", ServiceLinkedRoleArgs.builder()
 *             .serviceName("ops.elasticsearch.aliyuncs.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:resourcemanager:ServiceLinkedRole
 *     properties:
 *       serviceName: ops.elasticsearch.aliyuncs.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Service Linked Role can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/serviceLinkedRole:ServiceLinkedRole default <service_name>:<role_name>
 * ```
 * @property customSuffix The suffix of the role name. Only a few service linked roles support custom suffixes. The role name (including its suffix) must be 1 to 64 characters in length and can contain letters, digits, periods (.), and hyphens (-). For example, if the suffix is Example, the role name is ServiceLinkedRoleName_Example.
 * @property description The description of the service linked role.  This parameter must be specified for only the service linked roles that support custom suffixes. Otherwise, the preset value is used and cannot be modified. The description must be 1 to 1,024 characters in length.
 * @property serviceName The service name. For more information about the service name, see [Cloud services that support service linked roles](https://www.alibabacloud.com/help/en/doc-detail/160674.htm)
 */
public data class ServiceLinkedRoleArgs(
    public val customSuffix: Output<String>? = null,
    public val description: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.ServiceLinkedRoleArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.ServiceLinkedRoleArgs =
        com.pulumi.alicloud.resourcemanager.ServiceLinkedRoleArgs.builder()
            .customSuffix(customSuffix?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceLinkedRoleArgs].
 */
@PulumiTagMarker
public class ServiceLinkedRoleArgsBuilder internal constructor() {
    private var customSuffix: Output<String>? = null

    private var description: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The suffix of the role name. Only a few service linked roles support custom suffixes. The role name (including its suffix) must be 1 to 64 characters in length and can contain letters, digits, periods (.), and hyphens (-). For example, if the suffix is Example, the role name is ServiceLinkedRoleName_Example.
     */
    @JvmName("lpiukaimgojjsvnh")
    public suspend fun customSuffix(`value`: Output<String>) {
        this.customSuffix = value
    }

    /**
     * @param value The description of the service linked role.  This parameter must be specified for only the service linked roles that support custom suffixes. Otherwise, the preset value is used and cannot be modified. The description must be 1 to 1,024 characters in length.
     */
    @JvmName("upmmhdvtqosmaoyh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The service name. For more information about the service name, see [Cloud services that support service linked roles](https://www.alibabacloud.com/help/en/doc-detail/160674.htm)
     */
    @JvmName("wscnmlrsjdgkwhis")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The suffix of the role name. Only a few service linked roles support custom suffixes. The role name (including its suffix) must be 1 to 64 characters in length and can contain letters, digits, periods (.), and hyphens (-). For example, if the suffix is Example, the role name is ServiceLinkedRoleName_Example.
     */
    @JvmName("eeqoyyygnefxvdom")
    public suspend fun customSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSuffix = mapped
    }

    /**
     * @param value The description of the service linked role.  This parameter must be specified for only the service linked roles that support custom suffixes. Otherwise, the preset value is used and cannot be modified. The description must be 1 to 1,024 characters in length.
     */
    @JvmName("gqtemkabuggxqsec")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The service name. For more information about the service name, see [Cloud services that support service linked roles](https://www.alibabacloud.com/help/en/doc-detail/160674.htm)
     */
    @JvmName("oywspnkdpatrjmve")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ServiceLinkedRoleArgs = ServiceLinkedRoleArgs(
        customSuffix = customSuffix,
        description = description,
        serviceName = serviceName,
    )
}
