@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.SharedResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Shared Resource resource.
 * For information about Resource Manager Shared Resource and how to use it, see [What is Shared Resource](https://www.alibabacloud.com/help/en/resource-management/latest/api-resourcesharing-2020-01-10-associateresourceshare).
 * > **NOTE:** Available since v1.111.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const example = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/16",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     zoneId: example.then(example => example.zones?.[0]?.id),
 *     cidrBlock: "192.168.0.0/16",
 *     vpcId: exampleNetwork.id,
 *     vswitchName: name,
 * });
 * const exampleResourceShare = new alicloud.resourcemanager.ResourceShare("example", {resourceShareName: name});
 * const exampleSharedResource = new alicloud.resourcemanager.SharedResource("example", {
 *     resourceId: exampleSwitch.id,
 *     resourceShareId: exampleResourceShare.id,
 *     resourceType: "VSwitch",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * example = alicloud.get_zones(available_resource_creation="VSwitch")
 * example_network = alicloud.vpc.Network("example",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/16")
 * example_switch = alicloud.vpc.Switch("example",
 *     zone_id=example.zones[0].id,
 *     cidr_block="192.168.0.0/16",
 *     vpc_id=example_network.id,
 *     vswitch_name=name)
 * example_resource_share = alicloud.resourcemanager.ResourceShare("example", resource_share_name=name)
 * example_shared_resource = alicloud.resourcemanager.SharedResource("example",
 *     resource_id=example_switch.id,
 *     resource_share_id=example_resource_share.id,
 *     resource_type="VSwitch")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var example = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/16",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CidrBlock = "192.168.0.0/16",
 *         VpcId = exampleNetwork.Id,
 *         VswitchName = name,
 *     });
 *     var exampleResourceShare = new AliCloud.ResourceManager.ResourceShare("example", new()
 *     {
 *         ResourceShareName = name,
 *     });
 *     var exampleSharedResource = new AliCloud.ResourceManager.SharedResource("example", new()
 *     {
 *         ResourceId = exampleSwitch.Id,
 *         ResourceShareId = exampleResourceShare.Id,
 *         ResourceType = "VSwitch",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			ZoneId:      pulumi.String(example.Zones[0].Id),
 * 			CidrBlock:   pulumi.String("192.168.0.0/16"),
 * 			VpcId:       exampleNetwork.ID(),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleResourceShare, err := resourcemanager.NewResourceShare(ctx, "example", &resourcemanager.ResourceShareArgs{
 * 			ResourceShareName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewSharedResource(ctx, "example", &resourcemanager.SharedResourceArgs{
 * 			ResourceId:      exampleSwitch.ID(),
 * 			ResourceShareId: exampleResourceShare.ID(),
 * 			ResourceType:    pulumi.String("VSwitch"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourceShare;
 * import com.pulumi.alicloud.resourcemanager.ResourceShareArgs;
 * import com.pulumi.alicloud.resourcemanager.SharedResource;
 * import com.pulumi.alicloud.resourcemanager.SharedResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         final var example = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/16")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .cidrBlock("192.168.0.0/16")
 *             .vpcId(exampleNetwork.id())
 *             .vswitchName(name)
 *             .build());
 *         var exampleResourceShare = new ResourceShare("exampleResourceShare", ResourceShareArgs.builder()
 *             .resourceShareName(name)
 *             .build());
 *         var exampleSharedResource = new SharedResource("exampleSharedResource", SharedResourceArgs.builder()
 *             .resourceId(exampleSwitch.id())
 *             .resourceShareId(exampleResourceShare.id())
 *             .resourceType("VSwitch")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 192.168.0.0/16
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       zoneId: ${example.zones[0].id}
 *       cidrBlock: 192.168.0.0/16
 *       vpcId: ${exampleNetwork.id}
 *       vswitchName: ${name}
 *   exampleResourceShare:
 *     type: alicloud:resourcemanager:ResourceShare
 *     name: example
 *     properties:
 *       resourceShareName: ${name}
 *   exampleSharedResource:
 *     type: alicloud:resourcemanager:SharedResource
 *     name: example
 *     properties:
 *       resourceId: ${exampleSwitch.id}
 *       resourceShareId: ${exampleResourceShare.id}
 *       resourceType: VSwitch
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Shared Resource can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/sharedResource:SharedResource example <resource_share_id>:<resource_id>:<resource_type>
 * ```
 * @property resourceId The resource ID need shared.
 * @property resourceShareId The resource share ID of resource manager.
 * @property resourceType The resource type of should shared. Valid values:
 * - `VSwitch`.
 * - The following types are added after v1.173.0: `ROSTemplate` and `ServiceCatalogPortfolio`.
 * - The following types are added after v1.192.0: `PrefixList` and `Image`.
 * - The following types are added after v1.194.1: `PublicIpAddressPool`.
 * - The following types are added after v1.208.0: `KMSInstance`.
 */
public data class SharedResourceArgs(
    public val resourceId: Output<String>? = null,
    public val resourceShareId: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.SharedResourceArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.SharedResourceArgs =
        com.pulumi.alicloud.resourcemanager.SharedResourceArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .resourceShareId(resourceShareId?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SharedResourceArgs].
 */
@PulumiTagMarker
public class SharedResourceArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var resourceShareId: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value The resource ID need shared.
     */
    @JvmName("duqhxdaaaykoxpms")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The resource share ID of resource manager.
     */
    @JvmName("ysgyqbbwkcrllcip")
    public suspend fun resourceShareId(`value`: Output<String>) {
        this.resourceShareId = value
    }

    /**
     * @param value The resource type of should shared. Valid values:
     * - `VSwitch`.
     * - The following types are added after v1.173.0: `ROSTemplate` and `ServiceCatalogPortfolio`.
     * - The following types are added after v1.192.0: `PrefixList` and `Image`.
     * - The following types are added after v1.194.1: `PublicIpAddressPool`.
     * - The following types are added after v1.208.0: `KMSInstance`.
     */
    @JvmName("oslumtjbsvygdiyw")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The resource ID need shared.
     */
    @JvmName("jstomrjaoenxhddl")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The resource share ID of resource manager.
     */
    @JvmName("rdwdvnhowpucolek")
    public suspend fun resourceShareId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceShareId = mapped
    }

    /**
     * @param value The resource type of should shared. Valid values:
     * - `VSwitch`.
     * - The following types are added after v1.173.0: `ROSTemplate` and `ServiceCatalogPortfolio`.
     * - The following types are added after v1.192.0: `PrefixList` and `Image`.
     * - The following types are added after v1.194.1: `PublicIpAddressPool`.
     * - The following types are added after v1.208.0: `KMSInstance`.
     */
    @JvmName("auqjqljvhdlqixhq")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): SharedResourceArgs = SharedResourceArgs(
        resourceId = resourceId,
        resourceShareId = resourceShareId,
        resourceType = resourceType,
    )
}
