@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.SharedTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Shared Target resource.
 * For information about Resource Manager Shared Target and how to use it, see [What is Shared Target](https://www.alibabacloud.com/help/en/doc-detail/94475.htm).
 * > **NOTE:** Available since v1.111.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const default = alicloud.resourcemanager.getAccounts({});
 * const example = new alicloud.resourcemanager.ResourceShare("example", {resourceShareName: name});
 * const exampleSharedTarget = new alicloud.resourcemanager.SharedTarget("example", {
 *     resourceShareId: example.id,
 *     targetId: _default.then(_default => _default.ids?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.resourcemanager.get_accounts()
 * example = alicloud.resourcemanager.ResourceShare("example", resource_share_name=name)
 * example_shared_target = alicloud.resourcemanager.SharedTarget("example",
 *     resource_share_id=example.id,
 *     target_id=default.ids[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = AliCloud.ResourceManager.GetAccounts.Invoke();
 *     var example = new AliCloud.ResourceManager.ResourceShare("example", new()
 *     {
 *         ResourceShareName = name,
 *     });
 *     var exampleSharedTarget = new AliCloud.ResourceManager.SharedTarget("example", new()
 *     {
 *         ResourceShareId = example.Id,
 *         TargetId = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Ids[0])),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetAccounts(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := resourcemanager.NewResourceShare(ctx, "example", &resourcemanager.ResourceShareArgs{
 * 			ResourceShareName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewSharedTarget(ctx, "example", &resourcemanager.SharedTargetArgs{
 * 			ResourceShareId: example.ID(),
 * 			TargetId:        pulumi.String(_default.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetAccountsArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourceShare;
 * import com.pulumi.alicloud.resourcemanager.ResourceShareArgs;
 * import com.pulumi.alicloud.resourcemanager.SharedTarget;
 * import com.pulumi.alicloud.resourcemanager.SharedTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         final var default = ResourcemanagerFunctions.getAccounts();
 *         var example = new ResourceShare("example", ResourceShareArgs.builder()
 *             .resourceShareName(name)
 *             .build());
 *         var exampleSharedTarget = new SharedTarget("exampleSharedTarget", SharedTargetArgs.builder()
 *             .resourceShareId(example.id())
 *             .targetId(default_.ids()[0])
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:ResourceShare
 *     properties:
 *       resourceShareName: ${name}
 *   exampleSharedTarget:
 *     type: alicloud:resourcemanager:SharedTarget
 *     name: example
 *     properties:
 *       resourceShareId: ${example.id}
 *       targetId: ${default.ids[0]}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getAccounts
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Shared Target can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/sharedTarget:SharedTarget example <resource_share_id>:<target_id>
 * ```
 * @property resourceShareId The resource share ID of resource manager.
 * @property targetId The member account ID in resource directory.
 */
public data class SharedTargetArgs(
    public val resourceShareId: Output<String>? = null,
    public val targetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.SharedTargetArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.SharedTargetArgs =
        com.pulumi.alicloud.resourcemanager.SharedTargetArgs.builder()
            .resourceShareId(resourceShareId?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SharedTargetArgs].
 */
@PulumiTagMarker
public class SharedTargetArgsBuilder internal constructor() {
    private var resourceShareId: Output<String>? = null

    private var targetId: Output<String>? = null

    /**
     * @param value The resource share ID of resource manager.
     */
    @JvmName("tlfrdwqfqwugegvt")
    public suspend fun resourceShareId(`value`: Output<String>) {
        this.resourceShareId = value
    }

    /**
     * @param value The member account ID in resource directory.
     */
    @JvmName("ngyoocaseondqyqh")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The resource share ID of resource manager.
     */
    @JvmName("kunufbhnkcjpgmre")
    public suspend fun resourceShareId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceShareId = mapped
    }

    /**
     * @param value The member account ID in resource directory.
     */
    @JvmName("ymlqfmjvcbiwkfjl")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    internal fun build(): SharedTargetArgs = SharedTargetArgs(
        resourceShareId = resourceShareId,
        targetId = targetId,
    )
}
