@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetAccountDeletionCheckTaskPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccountDeletionCheckTask.
 * @property accountId The ID of the member that you want to delete.
 */
public data class GetAccountDeletionCheckTaskPlainArgs(
    public val accountId: String,
) :
    ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetAccountDeletionCheckTaskPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetAccountDeletionCheckTaskPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetAccountDeletionCheckTaskPlainArgs.builder()
            .accountId(accountId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountDeletionCheckTaskPlainArgs].
 */
@PulumiTagMarker
public class GetAccountDeletionCheckTaskPlainArgsBuilder internal constructor() {
    private var accountId: String? = null

    /**
     * @param value The ID of the member that you want to delete.
     */
    @JvmName("vmttiaewowpminow")
    public suspend fun accountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountId = mapped
    }

    internal fun build(): GetAccountDeletionCheckTaskPlainArgs = GetAccountDeletionCheckTaskPlainArgs(
        accountId = accountId ?: throw PulumiNullFieldException("accountId"),
    )
}
