@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetControlPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getControlPolicies.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Control Policy IDs.
 * @property language The language. Valid value `zh-CN`, `en`, and `ja`. Default value `zh-CN`.
 * @property nameRegex A regex string to filter results by Control Policy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property policyType The policy type of control policy. Valid values `System` and `Custom`.
 */
public data class GetControlPoliciesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val language: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val policyType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetControlPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetControlPoliciesPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetControlPoliciesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .language(language?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .policyType(policyType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetControlPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetControlPoliciesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var language: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var policyType: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("rvqebakdtvlbambg")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Control Policy IDs.
     */
    @JvmName("gfnswelteidmlcqx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Control Policy IDs.
     */
    @JvmName("qkxyykhlanvmltsi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The language. Valid value `zh-CN`, `en`, and `ja`. Default value `zh-CN`.
     */
    @JvmName("asdjqyntuqptskke")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.language = mapped
    }

    /**
     * @param value A regex string to filter results by Control Policy name.
     */
    @JvmName("ayxijqevcqacfule")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jpnjftmururyjban")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The policy type of control policy. Valid values `System` and `Custom`.
     */
    @JvmName("vlcseurjjvapnism")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyType = mapped
    }

    internal fun build(): GetControlPoliciesPlainArgs = GetControlPoliciesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        language = language,
        nameRegex = nameRegex,
        outputFile = outputFile,
        policyType = policyType,
    )
}
