@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetControlPolicyAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getControlPolicyAttachments.
 * @property language The language. Valid value `zh-CN`, `en`, and `ja`. Default value `zh-CN`
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property policyType The policy type of control policy. Valid values: `Custom` and `System`.
 * @property targetId The Id of target.
 */
public data class GetControlPolicyAttachmentsPlainArgs(
    public val language: String? = null,
    public val outputFile: String? = null,
    public val policyType: String? = null,
    public val targetId: String,
) :
    ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetControlPolicyAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetControlPolicyAttachmentsPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetControlPolicyAttachmentsPlainArgs.builder()
            .language(language?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .policyType(policyType?.let({ args0 -> args0 }))
            .targetId(targetId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetControlPolicyAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetControlPolicyAttachmentsPlainArgsBuilder internal constructor() {
    private var language: String? = null

    private var outputFile: String? = null

    private var policyType: String? = null

    private var targetId: String? = null

    /**
     * @param value The language. Valid value `zh-CN`, `en`, and `ja`. Default value `zh-CN`
     */
    @JvmName("uiwsmcghafnwawns")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.language = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qbfkdvmtffsreyfw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The policy type of control policy. Valid values: `Custom` and `System`.
     */
    @JvmName("utowyaiprkjhipqe")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyType = mapped
    }

    /**
     * @param value The Id of target.
     */
    @JvmName("eeguwfloqiovoyyo")
    public suspend fun targetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetId = mapped
    }

    internal fun build(): GetControlPolicyAttachmentsPlainArgs = GetControlPolicyAttachmentsPlainArgs(
        language = language,
        outputFile = outputFile,
        policyType = policyType,
        targetId = targetId ?: throw PulumiNullFieldException("targetId"),
    )
}
