@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetDelegatedAdministratorsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDelegatedAdministrators.
 * @property ids A list of Delegated Administrator IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property servicePrincipal The identification of the trusted service.
 */
public data class GetDelegatedAdministratorsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val servicePrincipal: String? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetDelegatedAdministratorsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetDelegatedAdministratorsPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetDelegatedAdministratorsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .servicePrincipal(servicePrincipal?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDelegatedAdministratorsPlainArgs].
 */
@PulumiTagMarker
public class GetDelegatedAdministratorsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var servicePrincipal: String? = null

    /**
     * @param value A list of Delegated Administrator IDs.
     */
    @JvmName("phrpmfcrxnnmjulr")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Delegated Administrator IDs.
     */
    @JvmName("gddfjuwybxldeuqa")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wixrogrcofdobhdd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ijsnimmvhmapvtsx")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("xyjexjtslgsvfcts")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The identification of the trusted service.
     */
    @JvmName("wnagpmmekdunuvrs")
    public suspend fun servicePrincipal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.servicePrincipal = mapped
    }

    internal fun build(): GetDelegatedAdministratorsPlainArgs = GetDelegatedAdministratorsPlainArgs(
        ids = ids,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        servicePrincipal = servicePrincipal,
    )
}
