@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetFoldersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFolders.
 * @property enableDetails Default to `false`. Set it to true can output more details.
 * @property ids A list of resource manager folders IDs.
 * @property nameRegex A regex string to filter results by folder name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property parentFolderId The ID of the parent folder.
 * @property queryKeyword The query keyword.
 */
public data class GetFoldersPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val parentFolderId: String? = null,
    public val queryKeyword: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetFoldersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetFoldersPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetFoldersPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .parentFolderId(parentFolderId?.let({ args0 -> args0 }))
            .queryKeyword(queryKeyword?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFoldersPlainArgs].
 */
@PulumiTagMarker
public class GetFoldersPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var parentFolderId: String? = null

    private var queryKeyword: String? = null

    /**
     * @param value Default to `false`. Set it to true can output more details.
     */
    @JvmName("huyahqyocwlqoyep")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of resource manager folders IDs.
     */
    @JvmName("eylucqjdhiyqnsad")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of resource manager folders IDs.
     */
    @JvmName("ykxqrsntadkvihki")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by folder name.
     */
    @JvmName("dytukgmrtvcoyflq")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("eqgxfawfruqhldkx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the parent folder.
     */
    @JvmName("iexkurhabnkhmcay")
    public suspend fun parentFolderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parentFolderId = mapped
    }

    /**
     * @param value The query keyword.
     */
    @JvmName("lyswxaslmkkcdrhr")
    public suspend fun queryKeyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queryKeyword = mapped
    }

    internal fun build(): GetFoldersPlainArgs = GetFoldersPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        parentFolderId = parentFolderId,
        queryKeyword = queryKeyword,
    )
}
