@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPolicies.
 * @property ids A list of Resource Manager Policy IDs.
 * @property nameRegex A regex string to filter results by policy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property policyType The type of the policy. If you do not specify this parameter, the system lists all types of policies. Valid values: `Custom` and `System`.
 */
public data class GetPoliciesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val policyType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetPoliciesPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetPoliciesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .policyType(policyType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetPoliciesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var policyType: String? = null

    /**
     * @param value A list of Resource Manager Policy IDs.
     */
    @JvmName("ysppprtgbnnxfnat")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Resource Manager Policy IDs.
     */
    @JvmName("jikiohrovjxmkilt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by policy name.
     */
    @JvmName("qgpddkfcqubcpesw")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bpyvnyhyewwvvhnk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The type of the policy. If you do not specify this parameter, the system lists all types of policies. Valid values: `Custom` and `System`.
     */
    @JvmName("oycjbiwbukqdkxau")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyType = mapped
    }

    internal fun build(): GetPoliciesPlainArgs = GetPoliciesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        policyType = policyType,
    )
}
