@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetPolicyAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPolicyAttachments.
 * @property language The language that is used to return the description of the system policy. Valid values:`en`: English, `zh-CN`: Chinese, `ja`: Japanese.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property policyName The name of the policy. The name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
 * @property policyType The type of the policy. Valid values: `Custom` and `System`.
 * @property principalName The name of the object to which the policy is attached.
 * @property principalType The type of the object to which the policy is attached. If you do not specify this parameter, the system lists all types of objects. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
 * @property resourceGroupId The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs. If you do not specify this parameter, the system lists all policy attachment records under the current account.
 */
public data class GetPolicyAttachmentsPlainArgs(
    public val language: String? = null,
    public val outputFile: String? = null,
    public val policyName: String? = null,
    public val policyType: String? = null,
    public val principalName: String? = null,
    public val principalType: String? = null,
    public val resourceGroupId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetPolicyAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetPolicyAttachmentsPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetPolicyAttachmentsPlainArgs.builder()
            .language(language?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .policyName(policyName?.let({ args0 -> args0 }))
            .policyType(policyType?.let({ args0 -> args0 }))
            .principalName(principalName?.let({ args0 -> args0 }))
            .principalType(principalType?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyAttachmentsPlainArgsBuilder internal constructor() {
    private var language: String? = null

    private var outputFile: String? = null

    private var policyName: String? = null

    private var policyType: String? = null

    private var principalName: String? = null

    private var principalType: String? = null

    private var resourceGroupId: String? = null

    /**
     * @param value The language that is used to return the description of the system policy. Valid values:`en`: English, `zh-CN`: Chinese, `ja`: Japanese.
     */
    @JvmName("vgahhgtcgbuwtwgl")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.language = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("mhivyulhmgtogidn")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the policy. The name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     */
    @JvmName("qtpkahdbpuboanum")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value The type of the policy. Valid values: `Custom` and `System`.
     */
    @JvmName("uwnsgpduddnfiiwj")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyType = mapped
    }

    /**
     * @param value The name of the object to which the policy is attached.
     */
    @JvmName("hxjkbplxbkhvohnk")
    public suspend fun principalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.principalName = mapped
    }

    /**
     * @param value The type of the object to which the policy is attached. If you do not specify this parameter, the system lists all types of objects. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
     */
    @JvmName("cynqbxvttbcdqyii")
    public suspend fun principalType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.principalType = mapped
    }

    /**
     * @param value The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs. If you do not specify this parameter, the system lists all policy attachment records under the current account.
     */
    @JvmName("wjuqcfvrpupxwlhq")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    internal fun build(): GetPolicyAttachmentsPlainArgs = GetPolicyAttachmentsPlainArgs(
        language = language,
        outputFile = outputFile,
        policyName = policyName,
        policyType = policyType,
        principalName = principalName,
        principalType = principalType,
        resourceGroupId = resourceGroupId,
    )
}
