@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetPolicyVersionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPolicyVersions.
 * @property enableDetails Default to `false`. Set it to true can output more details.
 * @property ids A list of policy version IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property policyName The name of the policy.
 * @property policyType The type of the policy. Valid values:`Custom` and `System`.
 */
public data class GetPolicyVersionsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val policyName: String,
    public val policyType: String,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetPolicyVersionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetPolicyVersionsPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetPolicyVersionsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .policyName(policyName.let({ args0 -> args0 }))
            .policyType(policyType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyVersionsPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyVersionsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var policyName: String? = null

    private var policyType: String? = null

    /**
     * @param value Default to `false`. Set it to true can output more details.
     */
    @JvmName("wbwkkxxxhciwepbe")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of policy version IDs.
     */
    @JvmName("ukahrrdpdpdudeup")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of policy version IDs.
     */
    @JvmName("vdthlqophuhyxabc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wvtyvwreypvpxqwj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("mltiruvjdhaotsxv")
    public suspend fun policyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value The type of the policy. Valid values:`Custom` and `System`.
     */
    @JvmName("diekathunrohwydc")
    public suspend fun policyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyType = mapped
    }

    internal fun build(): GetPolicyVersionsPlainArgs = GetPolicyVersionsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        outputFile = outputFile,
        policyName = policyName ?: throw PulumiNullFieldException("policyName"),
        policyType = policyType ?: throw PulumiNullFieldException("policyType"),
    )
}
