@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetResourceDirectoriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResourceDirectories.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetResourceDirectoriesPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetResourceDirectoriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetResourceDirectoriesPlainArgs = com.pulumi.alicloud.resourcemanager.inputs.GetResourceDirectoriesPlainArgs.builder()
        .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourceDirectoriesPlainArgs].
 */
@PulumiTagMarker
public class GetResourceDirectoriesPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xvsjlfmfbxhltvuj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetResourceDirectoriesPlainArgs = GetResourceDirectoriesPlainArgs(
        outputFile = outputFile,
    )
}
