@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetResourceSharesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResourceShares.
 * @property ids A list of Resource Share IDs.
 * @property nameRegex A regex string to filter results by Resource Share name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceShareName The name of resource share.
 * @property resourceShareOwner The owner of resource share, Valid values: `Self` and `OtherAccounts`.
 * @property status The status of resource share. Valid values: `Active`,`Deleted` and `Deleting`.
 */
public data class GetResourceSharesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceShareName: String? = null,
    public val resourceShareOwner: String,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetResourceSharesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetResourceSharesPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetResourceSharesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceShareName(resourceShareName?.let({ args0 -> args0 }))
            .resourceShareOwner(resourceShareOwner.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourceSharesPlainArgs].
 */
@PulumiTagMarker
public class GetResourceSharesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceShareName: String? = null

    private var resourceShareOwner: String? = null

    private var status: String? = null

    /**
     * @param value A list of Resource Share IDs.
     */
    @JvmName("iobvgxrfldgleyne")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Resource Share IDs.
     */
    @JvmName("udttlloheevighaj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Resource Share name.
     */
    @JvmName("psnqoykqkvwtccsr")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ebtnjgeiwwbknxjr")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of resource share.
     */
    @JvmName("kofsuofddscdtjha")
    public suspend fun resourceShareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceShareName = mapped
    }

    /**
     * @param value The owner of resource share, Valid values: `Self` and `OtherAccounts`.
     */
    @JvmName("dnkoiuvpgubwdvcy")
    public suspend fun resourceShareOwner(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceShareOwner = mapped
    }

    /**
     * @param value The status of resource share. Valid values: `Active`,`Deleted` and `Deleting`.
     */
    @JvmName("hlptvrhtglfwqavx")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetResourceSharesPlainArgs = GetResourceSharesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceShareName = resourceShareName,
        resourceShareOwner = resourceShareOwner ?: throw PulumiNullFieldException("resourceShareOwner"),
        status = status,
    )
}
