@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetSharedResourcesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSharedResources.
 * @property ids A list of shared resource IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceShareId The resource share ID of resource manager.
 * @property status The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
 */
public data class GetSharedResourcesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val resourceShareId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetSharedResourcesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetSharedResourcesPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetSharedResourcesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceShareId(resourceShareId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSharedResourcesPlainArgs].
 */
@PulumiTagMarker
public class GetSharedResourcesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var resourceShareId: String? = null

    private var status: String? = null

    /**
     * @param value A list of shared resource IDs.
     */
    @JvmName("lolompoulupddlfq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of shared resource IDs.
     */
    @JvmName("hetevieiwexbfmqk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ihspucxddwrfjaon")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The resource share ID of resource manager.
     */
    @JvmName("xfipckeelvnflghb")
    public suspend fun resourceShareId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceShareId = mapped
    }

    /**
     * @param value The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
     */
    @JvmName("oofxharpobyjhose")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetSharedResourcesPlainArgs = GetSharedResourcesPlainArgs(
        ids = ids,
        outputFile = outputFile,
        resourceShareId = resourceShareId,
        status = status,
    )
}
