@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.inputs

import com.pulumi.alicloud.resourcemanager.inputs.GetSharedTargetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSharedTargets.
 * @property ids A list of Shared Target IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceShareId The resource share ID of resource manager.
 * @property status The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
 */
public data class GetSharedTargetsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val resourceShareId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.inputs.GetSharedTargetsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.inputs.GetSharedTargetsPlainArgs =
        com.pulumi.alicloud.resourcemanager.inputs.GetSharedTargetsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceShareId(resourceShareId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSharedTargetsPlainArgs].
 */
@PulumiTagMarker
public class GetSharedTargetsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var resourceShareId: String? = null

    private var status: String? = null

    /**
     * @param value A list of Shared Target IDs.
     */
    @JvmName("ugfrohswjdnbjuni")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Shared Target IDs.
     */
    @JvmName("ksdciphqvgrmixds")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("loyfeavvgxukmrjq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The resource share ID of resource manager.
     */
    @JvmName("smiydasksawlhvay")
    public suspend fun resourceShareId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceShareId = mapped
    }

    /**
     * @param value The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
     */
    @JvmName("fsccgmvkddgujtlb")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetSharedTargetsPlainArgs = GetSharedTargetsPlainArgs(
        ids = ids,
        outputFile = outputFile,
        resourceShareId = resourceShareId,
        status = status,
    )
}
