@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccountDeletionCheckTask.
 * @property abandonAbleChecks The check items that you can choose to ignore for the member deletion. Each element contains the following attributes:
 * @property accountId
 * @property allowDelete Indicates whether the member can be deleted.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property notAllowReasons The reasons why the member cannot be deleted. Each element contains the following attributes:
 * @property status The status of the check.
 */
public data class GetAccountDeletionCheckTaskResult(
    public val abandonAbleChecks: List<GetAccountDeletionCheckTaskAbandonAbleCheck>,
    public val accountId: String,
    public val allowDelete: Boolean,
    public val id: String,
    public val notAllowReasons: List<GetAccountDeletionCheckTaskNotAllowReason>,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetAccountDeletionCheckTaskResult): GetAccountDeletionCheckTaskResult = GetAccountDeletionCheckTaskResult(
            abandonAbleChecks = javaType.abandonAbleChecks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetAccountDeletionCheckTaskAbandonAbleCheck.Companion.toKotlin(args0)
                })
            }),
            accountId = javaType.accountId(),
            allowDelete = javaType.allowDelete(),
            id = javaType.id(),
            notAllowReasons = javaType.notAllowReasons().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetAccountDeletionCheckTaskNotAllowReason.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
        )
    }
}
