@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId The ID of the account.
 * @property accountName (Available in v1.125.0+) The Alibaba Cloud account name of the member account.
 * @property displayName The name of the member account.
 * @property folderId The ID of the folder.
 * @property id The ID of the resource.
 * @property joinMethod The way in which the member account joined the resource directory.
 * @property joinTime The time when the member account joined the resource directory.
 * @property modifyTime The time when the member account was modified.
 * @property payerAccountId (Available in v1.124.3+) Settlement account ID. If the value is empty, the current account will be used for settlement.
 * @property resourceDirectoryId The ID of the resource directory.
 * @property status The status of account, valid values: `CreateCancelled`, `CreateExpired`, `CreateFailed`, `CreateSuccess`, `CreateVerifying`, `InviteSuccess`, `PromoteCancelled`, `PromoteExpired`, `PromoteFailed`, `PromoteSuccess`, and `PromoteVerifying`.
 * @property type The type of the member account.
 */
public data class GetAccountsAccount(
    public val accountId: String,
    public val accountName: String,
    public val displayName: String,
    public val folderId: String,
    public val id: String,
    public val joinMethod: String,
    public val joinTime: String,
    public val modifyTime: String,
    public val payerAccountId: String,
    public val resourceDirectoryId: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetAccountsAccount): GetAccountsAccount = GetAccountsAccount(
            accountId = javaType.accountId(),
            accountName = javaType.accountName(),
            displayName = javaType.displayName(),
            folderId = javaType.folderId(),
            id = javaType.id(),
            joinMethod = javaType.joinMethod(),
            joinTime = javaType.joinTime(),
            modifyTime = javaType.modifyTime(),
            payerAccountId = javaType.payerAccountId(),
            resourceDirectoryId = javaType.resourceDirectoryId(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
