@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccounts.
 * @property accounts A list of accounts. Each element contains the following attributes:
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of account IDs.
 * @property outputFile
 * @property status The status of the member account.
 */
public data class GetAccountsResult(
    public val accounts: List<GetAccountsAccount>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetAccountsResult): GetAccountsResult = GetAccountsResult(
            accounts = javaType.accounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetAccountsAccount.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
