@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attachmentCount The count of policy attachment.
 * @property controlPolicyName The name of policy.
 * @property description The description of policy.
 * @property effectScope The effect scope.
 * @property id The ID of the Control Policy.
 * @property policyDocument The policy document.
 * @property policyId The ID of policy.
 * @property policyType The type of policy.
 */
public data class GetControlPoliciesPolicy(
    public val attachmentCount: Int,
    public val controlPolicyName: String,
    public val description: String,
    public val effectScope: String,
    public val id: String,
    public val policyDocument: String,
    public val policyId: String,
    public val policyType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetControlPoliciesPolicy): GetControlPoliciesPolicy = GetControlPoliciesPolicy(
            attachmentCount = javaType.attachmentCount(),
            controlPolicyName = javaType.controlPolicyName(),
            description = javaType.description(),
            effectScope = javaType.effectScope(),
            id = javaType.id(),
            policyDocument = javaType.policyDocument(),
            policyId = javaType.policyId(),
            policyType = javaType.policyType(),
        )
    }
}
