@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getControlPolicies.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property language
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property policies
 * @property policyType
 */
public data class GetControlPoliciesResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val language: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val policies: List<GetControlPoliciesPolicy>,
    public val policyType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetControlPoliciesResult): GetControlPoliciesResult = GetControlPoliciesResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            language = javaType.language().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetControlPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
