@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getControlPolicyAttachments.
 * @property attachments
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property language
 * @property outputFile
 * @property policyType
 * @property targetId
 */
public data class GetControlPolicyAttachmentsResult(
    public val attachments: List<GetControlPolicyAttachmentsAttachment>,
    public val id: String,
    public val ids: List<String>,
    public val language: String? = null,
    public val outputFile: String? = null,
    public val policyType: String? = null,
    public val targetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetControlPolicyAttachmentsResult): GetControlPolicyAttachmentsResult = GetControlPolicyAttachmentsResult(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetControlPolicyAttachmentsAttachment.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            language = javaType.language().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
            targetId = javaType.targetId(),
        )
    }
}
