@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId The ID of the member account.
 * @property delegationEnabledTime The time when the member was specified as a delegated administrator account.
 * @property id The ID of the Delegated Administrator.
 * @property servicePrincipal The identity of the trusted service.
 */
public data class GetDelegatedAdministratorsAdministrator(
    public val accountId: String,
    public val delegationEnabledTime: String,
    public val id: String,
    public val servicePrincipal: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetDelegatedAdministratorsAdministrator): GetDelegatedAdministratorsAdministrator = GetDelegatedAdministratorsAdministrator(
            accountId = javaType.accountId(),
            delegationEnabledTime = javaType.delegationEnabledTime(),
            id = javaType.id(),
            servicePrincipal = javaType.servicePrincipal(),
        )
    }
}
