@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDelegatedAdministrators.
 * @property administrators
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property servicePrincipal
 */
public data class GetDelegatedAdministratorsResult(
    public val administrators: List<GetDelegatedAdministratorsAdministrator>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val servicePrincipal: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetDelegatedAdministratorsResult): GetDelegatedAdministratorsResult = GetDelegatedAdministratorsResult(
            administrators = javaType.administrators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetDelegatedAdministratorsAdministrator.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            servicePrincipal = javaType.servicePrincipal().map({ args0 -> args0 }).orElse(null),
        )
    }
}
