@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property folderId The ID of the folder.
 * @property folderName The name of the folder.
 * @property id The ID of the folder.
 * @property parentFolderId The ID of the parent folder.
 */
public data class GetFoldersFolder(
    public val folderId: String,
    public val folderName: String,
    public val id: String,
    public val parentFolderId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetFoldersFolder): GetFoldersFolder = GetFoldersFolder(
            folderId = javaType.folderId(),
            folderName = javaType.folderName(),
            id = javaType.id(),
            parentFolderId = javaType.parentFolderId(),
        )
    }
}
