@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getFolders.
 * @property enableDetails
 * @property folders A list of folders. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of folder IDs.
 * @property nameRegex
 * @property names A list of folder names.
 * @property outputFile
 * @property parentFolderId (Available in v1.114.0+)The ID of the parent folder.
 * @property queryKeyword
 */
public data class GetFoldersResult(
    public val enableDetails: Boolean? = null,
    public val folders: List<GetFoldersFolder>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val parentFolderId: String? = null,
    public val queryKeyword: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetFoldersResult): GetFoldersResult = GetFoldersResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            folders = javaType.folders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetFoldersFolder.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            parentFolderId = javaType.parentFolderId().map({ args0 -> args0 }).orElse(null),
            queryKeyword = javaType.queryKeyword().map({ args0 -> args0 }).orElse(null),
        )
    }
}
