@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property expireTime The time when the invitation expires.
 * @property handshakeId The ID of the invitation.
 * @property id The ID of the resource.
 * @property invitedAccountRealName (Available in v1.114.0+) The real name of the invited account.
 * @property masterAccountId The ID of the master account of the resource directory.
 * @property masterAccountName The name of the master account of the resource directory.
 * @property masterAccountRealName (Available in v1.114.0+) The real name of the master account of the resource directory.
 * @property modifyTime The time when the invitation was modified.
 * @property note The invitation note.
 * @property resourceDirectoryId The ID of the resource directory.
 * @property status The status of handshake, valid values: `Accepted`, `Cancelled`, `Declined`, `Deleted`, `Expired` and `Pending`.
 * @property targetEntity The ID or logon email address of the invited account.
 * @property targetType The type of the invited account.
 */
public data class GetHandshakesHandshake(
    public val expireTime: String,
    public val handshakeId: String,
    public val id: String,
    public val invitedAccountRealName: String,
    public val masterAccountId: String,
    public val masterAccountName: String,
    public val masterAccountRealName: String,
    public val modifyTime: String,
    public val note: String,
    public val resourceDirectoryId: String,
    public val status: String,
    public val targetEntity: String,
    public val targetType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetHandshakesHandshake): GetHandshakesHandshake = GetHandshakesHandshake(
            expireTime = javaType.expireTime(),
            handshakeId = javaType.handshakeId(),
            id = javaType.id(),
            invitedAccountRealName = javaType.invitedAccountRealName(),
            masterAccountId = javaType.masterAccountId(),
            masterAccountName = javaType.masterAccountName(),
            masterAccountRealName = javaType.masterAccountRealName(),
            modifyTime = javaType.modifyTime(),
            note = javaType.note(),
            resourceDirectoryId = javaType.resourceDirectoryId(),
            status = javaType.status(),
            targetEntity = javaType.targetEntity(),
            targetType = javaType.targetType(),
        )
    }
}
