@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHandshakes.
 * @property enableDetails
 * @property handshakes A list of Resource Manager Handshakes. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Resource Manager Handshake IDs.
 * @property outputFile
 * @property status The status of the invitation.
 */
public data class GetHandshakesResult(
    public val enableDetails: Boolean? = null,
    public val handshakes: List<GetHandshakesHandshake>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetHandshakesResult): GetHandshakesResult = GetHandshakesResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            handshakes = javaType.handshakes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetHandshakesHandshake.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
