@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attachmentCount The number of times the policy is referenced.
 * @property defaultVersion The default version of the policy.
 * @property description The description of the policy.
 * @property id The ID of the policy.
 * @property policyName The name of the policy.
 * @property policyType The type of the policy. If you do not specify this parameter, the system lists all types of policies. Valid values: `Custom` and `System`.
 * @property updateDate The time when the policy was updated.
 */
public data class GetPoliciesPolicy(
    public val attachmentCount: Int,
    public val defaultVersion: String,
    public val description: String,
    public val id: String,
    public val policyName: String,
    public val policyType: String,
    public val updateDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetPoliciesPolicy): GetPoliciesPolicy = GetPoliciesPolicy(
            attachmentCount = javaType.attachmentCount(),
            defaultVersion = javaType.defaultVersion(),
            description = javaType.description(),
            id = javaType.id(),
            policyName = javaType.policyName(),
            policyType = javaType.policyType(),
            updateDate = javaType.updateDate(),
        )
    }
}
