@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPolicies.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of policy IDs.
 * @property nameRegex
 * @property names A list of policy names.
 * @property outputFile
 * @property policies A list of policies. Each element contains the following attributes:
 * @property policyType The type of the policy.
 */
public data class GetPoliciesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val policies: List<GetPoliciesPolicy>,
    public val policyType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetPoliciesResult): GetPoliciesResult = GetPoliciesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
