@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attachDate The time when the policy was attached.
 * @property description The description of the policy.
 * @property id The ID of the Resource Manager Policy Attachment.
 * @property policyName The name of the policy. The name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
 * @property policyType The type of the policy. Valid values: `Custom` and `System`.
 * @property principalName The name of the object to which the policy is attached.
 * @property principalType The type of the object to which the policy is attached. If you do not specify this parameter, the system lists all types of objects. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
 * @property resourceGroupId The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs. If you do not specify this parameter, the system lists all policy attachment records under the current account.
 */
public data class GetPolicyAttachmentsAttachment(
    public val attachDate: String,
    public val description: String,
    public val id: String,
    public val policyName: String,
    public val policyType: String,
    public val principalName: String,
    public val principalType: String,
    public val resourceGroupId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetPolicyAttachmentsAttachment): GetPolicyAttachmentsAttachment = GetPolicyAttachmentsAttachment(
            attachDate = javaType.attachDate(),
            description = javaType.description(),
            id = javaType.id(),
            policyName = javaType.policyName(),
            policyType = javaType.policyType(),
            principalName = javaType.principalName(),
            principalType = javaType.principalType(),
            resourceGroupId = javaType.resourceGroupId(),
        )
    }
}
