@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPolicyAttachments.
 * @property attachments A list of Resource Manager Policy Attachment. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Resource Manager Policy Attachment IDs.
 * @property language
 * @property outputFile
 * @property policyName The name of the policy.
 * @property policyType The type of the policy.
 * @property principalName The name of the object to which the policy is attached.
 * @property principalType The type of the object to which the policy is attached.
 * @property resourceGroupId The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs.
 */
public data class GetPolicyAttachmentsResult(
    public val attachments: List<GetPolicyAttachmentsAttachment>,
    public val id: String,
    public val ids: List<String>,
    public val language: String? = null,
    public val outputFile: String? = null,
    public val policyName: String? = null,
    public val policyType: String? = null,
    public val principalName: String? = null,
    public val principalType: String? = null,
    public val resourceGroupId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetPolicyAttachmentsResult): GetPolicyAttachmentsResult = GetPolicyAttachmentsResult(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetPolicyAttachmentsAttachment.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            language = javaType.language().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
            principalName = javaType.principalName().map({ args0 -> args0 }).orElse(null),
            principalType = javaType.principalType().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
