@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPolicyVersions.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of policy version IDs.
 * @property outputFile
 * @property policyName
 * @property policyType
 * @property versions A list of policy versions. Each element contains the following attributes:
 */
public data class GetPolicyVersionsResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val policyName: String,
    public val policyType: String,
    public val versions: List<GetPolicyVersionsVersion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetPolicyVersionsResult): GetPolicyVersionsResult = GetPolicyVersionsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName(),
            policyType = javaType.policyType(),
            versions = javaType.versions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetPolicyVersionsVersion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
