@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the resource, the value is `<policy_name>`:`<version_id>`.
 * @property isDefaultVersion Indicates whether the policy version is the default version.
 * @property policyDocument (Available in v1.114.0+) The policy document of the policy version.
 * @property versionId The ID of the policy version.
 */
public data class GetPolicyVersionsVersion(
    public val id: String,
    public val isDefaultVersion: Boolean,
    public val policyDocument: String,
    public val versionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetPolicyVersionsVersion): GetPolicyVersionsVersion = GetPolicyVersionsVersion(
            id = javaType.id(),
            isDefaultVersion = javaType.isDefaultVersion(),
            policyDocument = javaType.policyDocument(),
            versionId = javaType.versionId(),
        )
    }
}
