@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of resource directory.
 * @property masterAccountId The ID of the master account.
 * @property masterAccountName The name of the master account.
 * @property resourceDirectoryId The ID of the resource directory.
 * @property rootFolderId The ID of the root folder.
 * @property status (Available in 1.120.0+.) The status of the control policy.
 */
public data class GetResourceDirectoriesDirectory(
    public val id: String,
    public val masterAccountId: String,
    public val masterAccountName: String,
    public val resourceDirectoryId: String,
    public val rootFolderId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetResourceDirectoriesDirectory): GetResourceDirectoriesDirectory = GetResourceDirectoriesDirectory(
            id = javaType.id(),
            masterAccountId = javaType.masterAccountId(),
            masterAccountName = javaType.masterAccountName(),
            resourceDirectoryId = javaType.resourceDirectoryId(),
            rootFolderId = javaType.rootFolderId(),
            status = javaType.status(),
        )
    }
}
