@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResourceDirectories.
 * @property directories A list of resource directories. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 */
public data class GetResourceDirectoriesResult(
    public val directories: List<GetResourceDirectoriesDirectory>,
    public val id: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetResourceDirectoriesResult): GetResourceDirectoriesResult = GetResourceDirectoriesResult(
            directories = javaType.directories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetResourceDirectoriesDirectory.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
