@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountId The ID of the Alibaba Cloud account to which the resource group belongs.
 * @property displayName The display name of the resource group.
 * @property id The ID of the resource group.
 * @property name The unique identifier of the resource group.
 * @property regionStatuses (Available since v1.114.0) The status of the resource group in all regions.
 * @property resourceGroupName (Available since v1.114.0) The unique identifier of the resource group.
 * @property status The status of the resource group. Valid values: `Creating`, `Deleted`, `Deleting`, `OK` and `PendingDelete`. **NOTE:** From version 1.114.0, `status` can be set to `Deleting`.
 */
public data class GetResourceGroupsGroup(
    public val accountId: String,
    public val displayName: String,
    public val id: String,
    public val name: String,
    public val regionStatuses: List<GetResourceGroupsGroupRegionStatus>,
    public val resourceGroupName: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetResourceGroupsGroup): GetResourceGroupsGroup = GetResourceGroupsGroup(
            accountId = javaType.accountId(),
            displayName = javaType.displayName(),
            id = javaType.id(),
            name = javaType.name(),
            regionStatuses = javaType.regionStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetResourceGroupsGroupRegionStatus.Companion.toKotlin(args0)
                })
            }),
            resourceGroupName = javaType.resourceGroupName(),
            status = javaType.status(),
        )
    }
}
