@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResourceGroups.
 * @property enableDetails
 * @property groups A list of resource groups. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of resource group IDs.
 * @property nameRegex
 * @property names A list of resource group identifiers.
 * @property outputFile
 * @property status The status of the regional resource group.
 */
public data class GetResourceGroupsResult(
    public val enableDetails: Boolean? = null,
    public val groups: List<GetResourceGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetResourceGroupsResult): GetResourceGroupsResult = GetResourceGroupsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetResourceGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
