@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Resource Share.
 * @property resourceShareId The ID of the resource share.
 * @property resourceShareName The name of resource share.
 * @property resourceShareOwner The owner of resource share.
 * @property status The status of resource share.
 */
public data class GetResourceSharesShare(
    public val id: String,
    public val resourceShareId: String,
    public val resourceShareName: String,
    public val resourceShareOwner: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetResourceSharesShare): GetResourceSharesShare = GetResourceSharesShare(
            id = javaType.id(),
            resourceShareId = javaType.resourceShareId(),
            resourceShareName = javaType.resourceShareName(),
            resourceShareOwner = javaType.resourceShareOwner(),
            status = javaType.status(),
        )
    }
}
