@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRoles.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of role IDs.
 * @property nameRegex
 * @property names A list of role names.
 * @property outputFile
 * @property roles A list of roles. Each element contains the following attributes:
 */
public data class GetRolesResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val roles: List<GetRolesRole>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetRolesResult): GetRolesResult = GetRolesResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            roles = javaType.roles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetRolesRole.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
