@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Alibaba Cloud Resource Name (ARN) of the RAM role.
 * @property assumeRolePolicyDocument (Available in v1.114.0+) The assume role policy document.
 * @property description The description of the RAM role.
 * @property id The ID of the role.
 * @property maxSessionDuration The maximum session duration of the RAM role.
 * @property roleId The ID of the role.
 * @property roleName The name of the role.
 * @property updateDate The time when the RAM role was updated.
 */
public data class GetRolesRole(
    public val arn: String,
    public val assumeRolePolicyDocument: String,
    public val description: String,
    public val id: String,
    public val maxSessionDuration: Int,
    public val roleId: String,
    public val roleName: String,
    public val updateDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetRolesRole): GetRolesRole = GetRolesRole(
            arn = javaType.arn(),
            assumeRolePolicyDocument = javaType.assumeRolePolicyDocument(),
            description = javaType.description(),
            id = javaType.id(),
            maxSessionDuration = javaType.maxSessionDuration(),
            roleId = javaType.roleId(),
            roleName = javaType.roleName(),
            updateDate = javaType.updateDate(),
        )
    }
}
