@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Shared Resource. It formats as `<resource_id>:<resource_type>`.
 * @property resourceId The ID of the shared resource.
 * @property resourceShareId The resource share ID of resource manager.
 * @property resourceType The type of shared resource.
 * @property status The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
 */
public data class GetSharedResourcesResource(
    public val id: String,
    public val resourceId: String,
    public val resourceShareId: String,
    public val resourceType: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetSharedResourcesResource): GetSharedResourcesResource = GetSharedResourcesResource(
            id = javaType.id(),
            resourceId = javaType.resourceId(),
            resourceShareId = javaType.resourceShareId(),
            resourceType = javaType.resourceType(),
            status = javaType.status(),
        )
    }
}
