@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSharedResources.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property resourceShareId The resource share ID of resource manager.
 * @property resources A list of Resource Manager Shared Resources. Each element contains the following attributes:
 * @property status The status of shared resource.
 */
public data class GetSharedResourcesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val resourceShareId: String? = null,
    public val resources: List<GetSharedResourcesResource>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetSharedResourcesResult): GetSharedResourcesResult = GetSharedResourcesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceShareId = javaType.resourceShareId().map({ args0 -> args0 }).orElse(null),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetSharedResourcesResource.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
