@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSharedTargets.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property resourceShareId The resource shared ID of resource manager.
 * @property status The status of shared target.
 * @property targets A list of Resource Manager Shared Targets. Each element contains the following attributes:
 */
public data class GetSharedTargetsResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val resourceShareId: String? = null,
    public val status: String? = null,
    public val targets: List<GetSharedTargetsTarget>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetSharedTargetsResult): GetSharedTargetsResult = GetSharedTargetsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceShareId = javaType.resourceShareId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            targets = javaType.targets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.resourcemanager.kotlin.outputs.GetSharedTargetsTarget.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
